#!/bin/bash

syslog_cfg_dir="/rw/config/syslog-ng"
syslog_cfg_file="$syslog_cfg_dir/syslog-ng-extra.conf"

server_addr=""
server_port=""
bsd=0

declare -a rules

index=0
while IFS= read -r line
do 

  if [[ $line =~ network\(\"(.+)\" ]];
  then
    bsd=1
    server_addr=${BASH_REMATCH[1]}
  fi
  
  if [[ $line =~ syslog\(\"(.+)\" ]];
  then
    bsd=0
    server_addr=${BASH_REMATCH[1]}
  fi
  
  if [[ $line =~ port\(([0-9]+)\) ]];
  then
    server_port=${BASH_REMATCH[1]}
  fi

  if [[ $line = *"filter f_remotelog"* ]];
  then
        
      if [[ $line =~ facility\((any|kern|user|mail|daemon|auth|syslog|lpr|news|uucp|cron|authpriv|ftp|ntp|security|console)\) ]];
      then
         facility=${BASH_REMATCH[1]}
      else
         facility="any"
      fi

      if [[ $line =~ level\((any|emerg|alert|crit|err|warning|notice|info|debug)..emerg\) ]];
      then
         level=${BASH_REMATCH[1]}
      else
         level="any"
      fi
      
      if [[ $line =~ match\((.+)\) ]];
      then
         match=${BASH_REMATCH[1]}
      else
         match="any"
      fi
      
      rules+=("rule= $facility $level $match")

      let index=index+1
  fi
done < "$syslog_cfg_file"

echo "serveraddr="$server_addr
echo "serverport="$server_port
echo "bsd="$bsd

for rule in "${rules[@]}"; do
    echo $rule
done
