#!/bin/bash

source /etc/device/info2.gg

if [ "${MAC1}" != "" ]; then

    PRIMARY=$(ls -1 /sys/class/net/ | grep enp | sed -n 1p)
    
    if [ "${PRIMARY}" != "" ]; then
    
        SECONDARY=$(ls -1 /sys/class/net/ | grep enp | sed -n 2p)

        if [ "${SECONDARY}" != "" ]; then

            #Convert the last 3 bytes from AA;BB:CC to the decimal of 0xAABBCC
            TEMPVAR=$(cat /sys/class/net/${PRIMARY}/address | cut -d":" -f4,5,6)
            MACLASTBYTESDECIMAL1=$(printf "%d\n" 0x${TEMPVAR//:})
            
            TEMPVAR=$(cat /sys/class/net/${SECONDARY}/address | cut -d":" -f4,5,6)
            MACLASTBYTESDECIMAL2=$(printf "%d\n" 0x${TEMPVAR//:})    

            if [ "${MACLASTBYTESDECIMAL1}" -gt "${MACLASTBYTESDECIMAL2}" ]; then
            
                TEMPVAR=${PRIMARY}
                PRIMARY=${SECONDARY}
                SECONDARY=${TEMPVAR}
            
            fi
            
        fi

        MAC1COLON=$(echo ${MAC1} | sed "s/-/:/g")
        /usr/bin/macchanger --mac=${MAC1COLON} ${PRIMARY}

        if [ "${MAC2}" != "" ] && [ "${SECONDARY}" != "" ]; then

            MAC2COLON=$(echo ${MAC2} | sed "s/-/:/g")
            /usr/bin/macchanger --mac=${MAC2COLON} ${SECONDARY}

        fi
    
    fi

fi
