#!/bin/sh

if [ "$1" == "" ]; then

    REDIRECTERRORS=/dev/null

else

    REDIRECTERRORS=$1

fi

PMCSETTING=$(cat /etc/device/info1.gg | grep 'PMCSETTING' | cut -f2 -d'=')

if [ -f '/etc/device/info2.gg' ]; then

    PMCSETTINGINFO2=$(cat /etc/device/info2.gg | grep 'PMCSETTING' | cut -f2 -d'=')
    
    if [ "${PMCSETTINGINFO2}" != "" ]; then
    
        if [ "${PMCSETTING}" != "${PMCSETTINGINFO2}" ]; then
        
            PMCSETTING=${PMCSETTINGINFO2}
        
        fi
    
    fi

fi

SV2DRIVER=$(/usr/local/bin/MtxBoardInfo >& /dev/null ; echo $?)

if [ ${SV2DRIVER} -eq "0" ]; then

    /usr/local/bin/MtxResetCtrl -sps ${PMCSETTING} 2> ${REDIRECTERRORS}

else

    ./InitMemContext >& /dev/null
    ./MtxResetCtrl-NoDrv -sps ${PMCSETTING} 2> ${REDIRECTERRORS}

fi
