#!/bin/sh

echo "$3" | grep "SLOT" > /dev/null

if [ "$?" == "0" ]; then

    if [ "$4" == "" ]; then

        REDIRECTERRORS=/dev/null

    else

        REDIRECTERRORS=$4

    fi
    
    ./MtxFpgaFlasher -f $1.bit $2 $3 2> ${REDIRECTERRORS}

    if [ $? != 0 ]; then
    
        PCBNUM=$(./MtxBoardInfo-NoDrv | grep PcbNumber: | tr '-' ' ' | awk '{print $2}')
        PCBREV=$(./MtxBoardInfo-NoDrv | grep "PcbRevision:" | cut -f2 -d 'x')
        
        if [ "$PCBNUM" == "7479" ] && [ $PCBREV -gt 2 ] ; then
        
            ./MtxFpgaFlasher -f $1.bit $2 $3 -forcespi 2> ${REDIRECTERRORS}
            
        else
        
            ./MtxFpgaFlasher -f $1.xsvf $2 $3 2> ${REDIRECTERRORS}
            
        fi
    fi

else

    if [ "$3" == "" ]; then

        REDIRECTERRORS=/dev/null

    else

        REDIRECTERRORS=$3

    fi
    
    ./MtxFpgaFlasher -f $1.bit $2 2> ${REDIRECTERRORS}

    if [ $? != 0 ]; then
    
        PCBNUM=$(./MtxBoardInfo-NoDrv | grep PcbNumber: | tr '-' ' ' | awk '{print $2}')
        PCBREV=$(./MtxBoardInfo-NoDrv | grep "PcbRevision:" | cut -f2 -d 'x')
        
        if [ "$PCBNUM" == "7479" ] && [ $PCBREV -gt 2 ] ; then
        
            ./MtxFpgaFlasher -f $1.bit $2 -forcespi 2> ${REDIRECTERRORS}
            
        else
        
            ./MtxFpgaFlasher -f $1.xsvf $2 2> ${REDIRECTERRORS}
            

        fi
    fi

fi


