#!/bin/sh

if [ "$1" == "" ] || [ "$1" == "--help" ]; then

    echo ""
    echo "Reads EDID from dev kit add-in card."
    echo ""
    echo "Usage:"
    echo "readedid-devkit.sh <one-based connector index> SLOT<one-based board index>"
    echo ""
    echo "Example:"
    echo "readedid-devkit.sh 1 SLOT1"
    echo ""
    
else

    index=$1
    index=$((index-1))
    slotindex=$(echo $2 | cut -f2 -d'T')    
    SV2DRIVER=$(/usr/local/bin/MtxBoardInfo >& /dev/null ; echo $?)

    if [ "$3" == "" ]; then

        REDIRECTERRORS=/dev/null

    else

        REDIRECTERRORS=$3

    fi
    
    if [ ${SV2DRIVER} -eq "0" ]; then

        /usr/local/bin/MtxEdidFlasher -l > EDID_$2_$1.txt 2> ${REDIRECTERRORS}

    else

        ./InitMemContext >& /dev/null
        ./MtxEdidFlasher-NoDrv -l > EDID_$2_$1.txt 2> ${REDIRECTERRORS}

    fi
    
    index=$(cat EDID_$2_$1.txt | grep "Add-in slot$slotindex HDMI$1" | cut -f2 -d'#' | cut -f1 -d' ')
    
    if [ ${SV2DRIVER} -eq "0" ]; then

        /usr/local/bin/MtxEdidFlasher -c $index -d > /tmp/edid.dat 2> ${REDIRECTERRORS}

    else

        ./MtxEdidFlasher-NoDrv -c $index -d > /tmp/edid.dat 2> ${REDIRECTERRORS}

    fi
    
    cat /tmp/edid.dat
    rm /tmp/edid.dat >& /dev/null
    
fi
