#!/bin/bash

source /etc/device/info2.gg

if [ "${CONTROL1}" != "" ]; then

    #FTP
    iptables -A INPUT -p tcp --dport 21 -j DROP
    ip6tables -A INPUT -p tcp --dport 21 -j DROP

    #SSH
    iptables -A INPUT -p tcp --dport 22 -j DROP
    ip6tables -A INPUT -p tcp --dport 22 -j DROP

    #TELNET
    iptables -A INPUT -p tcp --dport 23 -j DROP
    ip6tables -A INPUT -p tcp --dport 23 -j DROP

    #HTTPs
    iptables -A INPUT -p tcp --dport 443 -j DROP
    ip6tables -A INPUT -p tcp --dport 443 -j DROP

    #HTTPs non-standard port used by MC4W
    iptables -A INPUT -p tcp --dport 46272 -j DROP
    ip6tables -A INPUT -p tcp --dport 46272 -j DROP


    # loop forever
    while [ "fred" == "fred" ]; do

        if [ "${IPCONTROL1}" != "" ]; then
        
            OLDIPCONTROL1="${IPCONTROL1}"
            IPCONTROL1=""
        
        fi
        
        if [ "${IPCONTROL2}" != "" ]; then
        
            OLDIPCONTROL2="${IPCONTROL2}"
            IPCONTROL2=""
        
        fi
    
        IPCONTROL1=$(getent hosts ${CONTROL1} | cut -f1 -d' ')
        
        if [ "${CONTROL2}" != "" ]; then
        
            IPCONTROL2=$(getent hosts ${CONTROL2} | cut -f1 -d' ')
        
        fi
        
        if [ "${OLDIPCONTROL1}" != "" ] && [ "${OLDIPCONTROL1}" != "${IPCONTROL1}" ]; then        
        
            iptables -D INPUT -p tcp -s ${OLDIPCONTROL1}/32  --dport 21 -j DROP
            iptables -D INPUT -p tcp -s ${OLDIPCONTROL1}/32  --dport 22 -j DROP
            iptables -D INPUT -p tcp -s ${OLDIPCONTROL1}/32  --dport 23 -j DROP
            iptables -D INPUT -p tcp -s ${OLDIPCONTROL1}/32  --dport 443 -j DROP
            iptables -D INPUT -p tcp -s ${OLDIPCONTROL1}/32  --dport 46272 -j DROP
            OLDIPCONTROL1=""
        
        fi
        
        if [ "${IPCONTROL1}" != "" ] && [ "${IPCONTROL1}" != "${OLDIPCONTROL1}" ]; then
        
            iptables -I INPUT 1 -p tcp -s ${IPCONTROL1}  --dport 21 -j ACCEPT
            iptables -I INPUT 1 -p tcp -s ${IPCONTROL1}  --dport 22 -j ACCEPT
            iptables -I INPUT 1 -p tcp -s ${IPCONTROL1}  --dport 23 -j ACCEPT
            iptables -I INPUT 1 -p tcp -s ${IPCONTROL1}  --dport 443 -j ACCEPT
            iptables -I INPUT 1 -p tcp -s ${IPCONTROL1}  --dport 46272 -j ACCEPT
        
        fi
    
        if [ "${OLDIPCONTROL2}" != "" ] && [ "${OLDIPCONTROL2}" != "${IPCONTROL2}" ]; then        
        
            iptables -D INPUT -p tcp -s ${OLDIPCONTROL2}/32  --dport 21 -j DROP
            iptables -D INPUT -p tcp -s ${OLDIPCONTROL2}/32  --dport 22 -j DROP
            iptables -D INPUT -p tcp -s ${OLDIPCONTROL2}/32  --dport 23 -j DROP
            iptables -D INPUT -p tcp -s ${OLDIPCONTROL2}/32  --dport 443 -j DROP
            iptables -D INPUT -p tcp -s ${OLDIPCONTROL2}/32  --dport 46272 -j DROP
            OLDIPCONTROL2=""
        
        fi
        
        if [ "${IPCONTROL2}" != "" ] && [ "${IPCONTROL2}" != "${OLDIPCONTROL2}" ]; then
        
            iptables -I INPUT 1 -p tcp -s ${IPCONTROL2}  --dport 21 -j ACCEPT
            iptables -I INPUT 1 -p tcp -s ${IPCONTROL2}  --dport 22 -j ACCEPT
            iptables -I INPUT 1 -p tcp -s ${IPCONTROL2}  --dport 23 -j ACCEPT
            iptables -I INPUT 1 -p tcp -s ${IPCONTROL2}  --dport 443 -j ACCEPT
            iptables -I INPUT 1 -p tcp -s ${IPCONTROL2}  --dport 46272 -j ACCEPT
        
        fi

        sleep 5

    done

fi
