#!/bin/sh
#
# Called from udev
#
# Attempt to mount any added block devices and umount any removed devices
ACTION=add
DEVICE=$(echo $1 | cut -f1 -d'_')
DEVNAME="/dev/${DEVICE}"

ID_FS_TYPE=$(udevadm info $DEVNAME | grep ID_FS_TYPE | cut -f 2 -d '=')
MAJOR=$(echo $1 | cut -f2 -d'_')
MINOR=$(echo $1 | cut -f3 -d'_')
MOUNT="/bin/mount"
PMOUNT="/usr/bin/pmount"
UMOUNT="/bin/umount"

for line in `grep -v ^# /etc/udev/mount.blacklist`
do
    if [ ` expr match "$DEVNAME" "$line" ` -gt 0 ];
    then
        logger "udev/mount.sh" "[$DEVNAME] is blacklisted, ignoring"
        exit 0
    fi
done

DATETIME=$(date)
LABEL=$(ls -l /dev/disk/by-label/ | grep "${DEVICE}" | cut -f1 -d'>' | cut -f2 -d':' | cut -f2 -d' ')

if [ "${LABEL}" == "" ]; then

    LABEL="UNLABELLED_${DEVICE}"
    
else

    if [ -d "/media/labels/${LABEL}" ]; then
    
        EXTRALABELNUMBER=2
    
        while [ -d "/media/labels/${LABEL}_${EXTRALABELNUMBER}"]
        do
            EXTRALABELNUMBER=$((EXTRALABELNUMBER + 1))
        done
    
        LABEL=${LABEL}_${EXTRALABELNUMBER}
    fi
fi

automount() {   

        name="`basename "$DEVNAME"`"

    ! test -d "/media/$name" && mkdir -p "/media/$name"
    # Silent util-linux's version of mounting auto
    if [ "x`readlink $MOUNT`" = "x/bin/mount.util-linux" ] ;
    then
        MOUNT="$MOUNT -o silent"
    fi
    
    # If filesystem type is vfat, change the ownership group to 'disk', and
    # grant it with  w/r/x permissions.
    case $ID_FS_TYPE in
    vfat|fat)
        MOUNT="$MOUNT -o umask=007,gid=`awk -F':' '/^disk/{print $3}' /etc/group`"
        ;;
    # TODO
    *)
        ;;
    esac

    if ! $MOUNT -o noatime -t auto $DEVNAME "/media/$name"
    then
        #logger "mount.sh/automount" "$MOUNT -t auto $DEVNAME \"/media/$name\" failed!"
        rm_dir "/media/$name"
    else
        logger "mount.sh/automount" "Auto-mount of [/media/$name] successful"
        touch "/tmp/.automount-$name"
    fi  

    if [[ -f /media/$name/FirmwareUpdater/LocalUpdater.exe ]] ; then
    
        if [[ -f /rw/lock ]] ; then
        
            echo "locked"
            
        else
        
            systemctl stop sv2_updater-webservice-host.service
        
            if [[ -f /usr/local/bin/MtxBoardInfo ]] ; then
            
                SV2DRIVER=$(/usr/local/bin/MtxBoardInfo >& /dev/null ; echo $?)
            
            else
            
                SV2DRIVER=1
            
            fi
        
            if [ ${SV2DRIVER} -eq "0" ]; then

                /usr/local/bin/MtxSetLed -i 0 -c 3 -b 3


            else

                /usr/sbin/MtxSetLed-NoDrv -i 0 -c 3 -b 3

            fi
            
            LOCALFOLDER=/rw/firmware/validating
        
            mkdir -p ${LOCALFOLDER}
            rm -f ${LOCALFOLDER}/*
            rm -f /rw/firmware/new/*
            cp /media/$name/FirmwareUpdater/* ${LOCALFOLDER}/
            cd /usr/local/bin/
            mono ./Validator.exe ${LOCALFOLDER}/
            
            systemctl start sv2_updater-webservice-host.service
            
        fi
        
    else
    
        if [[ -f /usr/local/bin/info.sh ]] ; then
        
            /usr/local/bin/info.sh /media/$name
            
        fi
    fi
}
    
rm_dir() {
    # We do not want to rm -r populated directories
    if test "`find "$1" | wc -l | tr -d " "`" -lt 2 -a -d "$1"
    then
        ! test -z "$1" && rm -r "$1"
    else
        logger "mount.sh/automount" "Not removing non-empty directory [$1]"
    fi
}

# No ID_FS_TYPE for cdrom device, yet it should be mounted
name="`basename "$DEVNAME"`"
[ -e /sys/block/$name/device/media ] && media_type=`cat /sys/block/$name/device/media`

if [ "$ACTION" = "add" ] && [ -n "$DEVNAME" ]; then
        echo 'Mounted USB drive'
fi

if [ "$ACTION" = "add" ] && [ -n "$DEVNAME" ] && [ -n "$ID_FS_TYPE" -o "$media_type" = "cdrom" ]; then
    if [ -x "$PMOUNT" ]; then
        $PMOUNT $DEVNAME 2> /dev/null
    elif [ -x $MOUNT ]; then
            $MOUNT $DEVNAME 2> /dev/null
    fi
    
    # If the device isn't mounted at this point, it isn't
    # configured in fstab (note the root filesystem can show up as
    # /dev/root in /proc/mounts, so check the device number too)
    if expr $MAJOR "*" 256 + $MINOR != `stat -c %d /`; then
        grep -q "^$DEVNAME " /proc/mounts || automount
    fi
    
    mkdir -p /media/labels/
    rm -f /media/labels/${LABEL}
    ln -s /media/${DEVICE} /media/labels/${LABEL}
    PIDLINE=$(ps -ef | grep [S]V2.Device.exe)
    
    if [ "${PIDLINE}" != "" ]; then
        PIDINDEX=1
        SV2DEVICEEXEPID=""
        
        while [ "${SV2DEVICEEXEPID}" == "" ]; do   
            PIDINDEX=$((PIDINDEX+1))
            SV2DEVICEEXEPID=$(echo "${PIDLINE}" | cut -f${PIDINDEX} -d' ')
        done
        
        if [ "${SV2DEVICEEXEPID}" != "" ]; then
            kill -USR1 ${SV2DEVICEEXEPID}
        fi
    fi
fi



if [ "$ACTION" = "remove" ] && [ -x "$UMOUNT" ] && [ -n "$DEVNAME" ]; then
    for mnt in `cat /proc/mounts | grep "$DEVNAME" | cut -f 2 -d " " `
    do
        $UMOUNT $mnt
    done
    
    # Remove empty directories from auto-mounter
    name="`basename "$DEVNAME"`"
    test -e "/tmp/.automount-$name" && rm_dir "/media/$name"
fi
