#!/bin/sh

if [ "$5" == "" ]; then

    REDIRECTERRORS=/dev/null

else

    REDIRECTERRORS=$5

fi

MTXPROGDSPCMDLINE=$(ps -ef | grep [M]txProgressBarDisplay | cut -f4 -d':')

if [ "${MTXPROGDSPCMDLINE}" != "" ]; then

    MTXPROGDSPCMDLINE=${MTXPROGDSPCMDLINE:2:200}
    killall MtxProgressBarDisplay-NoDrv
    sleep 2

fi

./MtxFpgaFlasher -fpga 0 -vf $1.bin
ENCRYPTED=$?

if [ "${MTXPROGDSPCMDLINE}" != "" ]; then

    ${MTXPROGDSPCMDLINE} &
    sleep 10

fi

if [ "${ENCRYPTED}" != "0" ]; then

    ./MtxFpgaFlasher -fpga 0 -f $1.bit $2 $3 $4 2> ${REDIRECTERRORS}

    if [ $? != 0 ]; then

        ./MtxFpgaFlasher -fpga 0 -f $1.bit $2 $3 $4 -forcespi 2> ${REDIRECTERRORS}

    fi

    if [ $? != 0 ]; then

        echo "Failed flashing FPGA 1..."

    else

        ./MtxFpgaFlasher -fpga 0 -vf $1.bin

        if [ $? == 0 ]; then

            ./MtxFpgaFlasher -fpga 0 -f $1.bin $2 $3 $4 2> ${REDIRECTERRORS}

        else

            echo "Failed flashing FPGA 1..."

        fi

    fi

else

    ./MtxFpgaFlasher -fpga 0 -f $1.bin $2 $3 $4 2> ${REDIRECTERRORS}

    if [ $? != 0 ]; then
    
        ./MtxFpgaFlasher -fpga 0 -f $1.bin $2 $3 $4 -forcespi 2> ${REDIRECTERRORS}

    fi

    if [ $? != 0 ]; then

        echo "Failed flashing FPGA 1..."

    fi

fi

if [ "${MTXPROGDSPCMDLINE}" != "" ]; then

    killall MtxProgressBarDisplay-NoDrv
    sleep 2

fi


