#!/bin/bash

declare -a list=("upnp.service"
                 "extio3_tx.service"
                 "extio3_rx.service"
                 "extio3_xorg.service"
                 "sv2_device.service"
                 "sv2_command-webservice-host-core.service"
                 "sv2_webservice-host.service"
                 "sv2_updater-webservice-host.service"
                 "panopto.service"
                 )
declare -i nbChange=0

if [ -z $2 ]; then
   declare word="WatchdogSec"
else
   declare word="$2"
fi

func()
{
    isSet=false
    check=$(echo $3 | grep "#")
    if [ "$1" == "enable" ]; then
        replacement=$(echo $3 | grep -o "${word}.*")
        if [ "${check}" == "" ]; then isSet=true; fi
        setWord="enabled"
    else
        replacement="#${3}"
        if [ "${check}" != "" ]; then isSet=true; fi
        setWord="disabled"
    fi

    if $isSet; then
       echo "${word} is already ${setWord} for ${2}"
    else
       sed -i "/${3}/c\\${replacement}" "/lib/systemd/system/${2}"
    fi
}

if [ "$1" != "enable" ] && [ "$1" != "disable" ]; then
    echo "You must give a valid parameter : enable or disable"
    exit 1
fi

for item in "${list[@]}"
do
   if [ -e "/lib/systemd/system/${item}" ]; then
      line=$(cat "/lib/systemd/system/${item}" | grep "${word}")
      if [ "$line" == "" ]; then
         echo "The line ${word} does not exist in /lib/systemd/system/${item}."
         continue
      fi
      result=$(func "$1" "$item" "$line")
      if [ "${result}" == "" ]; then
         systemctl restart "$item"
         nbChange=$((nbChange+1))
      else
         echo $result
      fi
   fi
done

if [ $nbChange -gt 0 ]; then
   systemctl daemon-reload
   echo daemon is reloaded
fi
