#!/bin/sh

if [ "$1" == "" ] || [ "$1" == "--help" ]; then

    echo ""
    echo "Writes EDID to SV2-based device."
    echo ""
    echo "Usage:"
    echo "writeedid.sh <one-based connector index> <path to EDID file>"
    echo ""
    echo "Example:"
    echo "writeedid.sh 1 /tmp/firmwareupdate/Edid-Mura-1.bin"
    echo ""

else
    
    index=$1
    index=$((index-1))
    
    if [ -z "$3" ]; then
        snparam=""
    else
        snparam="-s $3"
    fi
    
    if [ "$4" == "" ]; then

        REDIRECTERRORS=/dev/null

    else

        REDIRECTERRORS=$4

    fi   
    
    SV2DRIVER=$(/usr/local/bin/MtxBoardInfo >& /dev/null ; echo $?)

    if [ ${SV2DRIVER} -eq "0" ]; then

        /usr/local/bin/MtxEdidFlasher -f $2 -c $index $snparam 2> ${REDIRECTERRORS}

    else

        ./InitMemContext >& /dev/null
        ./MtxEdidFlasher-NoDrv -f $2 -c $index $snparam 2> ${REDIRECTERRORS}

    fi
    
fi
