#!/bin/bash
# Matrox Info Script 01 07 2020
#This script will return all basic MEOS information

#to prevent Error Samba Message: "mkdir failed on directory /var/lib/samba/msg.lock: Read-only file system"
#mount -o remount,rw /

LOGPATH=/var/log
LOGFILE=Minfo.log
WHITE='\033[1;01m'
BLUE='\033[1;34m'
CYAN='\033[0;36m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color                                               
#DISTRIBUTION=$(cat /etc/os-release | grep 'PRETTY_NAME=' | cut -f2 -d=)
KERNEL=$(uname -smr)

if ls /etc/os-release 1> /dev/null 2>&1; then
    PKGNEW=$(cat /etc/os-release | grep   'VERSION_ID' | cut -f2 -d= | tr -d \")
else
    PKGNEW=$(cat /usr/lib/os-release | grep   'VERSION_ID' | cut -f2 -d= | tr -d \")
fi

LIB=$(rpm -q --queryformat '%{version}-%{release}\n' liberatus-runtime)
UPNPSERVICE=$(systemctl is-active upnp)
FDISK=$(fdisk -l | grep mmcblk0p)
ROOTSPACE=$(df -h | grep -A 1 File)
RWSPACE=$(df -h | grep rw)
COREBOOT=$(cat /rw/firmware/info3.gg | grep coreboot -i | cut -f2 -d '=')
APACHE=$(apachectl -v 2>/dev/null | grep -m1 version | cut -f3,3 -d' ')
nginx_installed=$(rpm -qa nginx)
NGINX=$(echo "$nginx_installed" | cut -d '-' -f 2)
BUSYBOX=$(busybox | grep -m1 BusyBox| cut -f2,2 -d' ')
STRONGSWAN=$(swanctl | grep -m1 swanctl | cut -f1,2 -d' ')
CONNMAN=$(connmand -v)
OPENSSH=$(echo ~ | nc localhost 22 | grep -m1 SSH)
OPENSSL=$(openssl version)
#SAMBAV=$(smbstatus | grep version | cut -f3,3 -d' ')
SNMPNET=$(snmpd -version | grep -m1 version | cut -f4,4 -d' ')

function DisplayBoardSecurityEcho()
{       
        echo
        echo -e ${CYAN}"========================================================="${NC}
        echo -e ${CYAN}"SECURITY INFORMATION:"${NC}
        echo
        # Check if Apache version is not empty
        if [ -n "$APACHE" ]; then
            echo "Apache version:         $APACHE"
        fi
        # Check if NGINX version is not empty
        if [ -n "$NGINX" ]; then
            echo "NGINX version:          $NGINX"
        fi  
        echo "BusyBox version:        $BUSYBOX"
        echo "StrongsWAN version:     $STRONGSWAN"
        echo "Connman version:        $CONNMAN"
        echo "OpenSSH version:        $OPENSSH"
        echo "OpenSSL version:        $OPENSSL"
        #echo "Samba version:          $SAMBAV"
        echo "SNMP version:           $SNMPNET"
        echo -e ${CYAN}"========================================================="${NC}
        echo
}

function DisplayBoardEcho()
{        
        echo -e ${BLUE}"################################################################################"${NC}
        echo -e ${WHITE}"BOARD INFORMATION:"${NC}
        echo
        echo -e "IP Address:"${WHITE}
        ifconfig | grep  'inet addr:'
        echo -e ${NC}
        echo "MEOS DISTRIBUTION:              $PKGNEW"
        echo "Kernel version:                 $KERNEL"
        echo "Coreboot:                       $COREBOOT"
        echo "Liberatus Runtime:              $LIB"        
        echo "UPNP Service:                   $UPNPSERVICE"
        echo 
        echo -e ${WHITE}"eMMC Partition Information:"${NC}
        echo "$FDISK"
        echo 
        echo -e ${WHITE}"eMMC Usage:"${NC}
        echo "$ROOTSPACE"
        echo "$RWSPACE"
        DisplayBoardSecurityEcho
}

DisplayBoardEcho
DisplayBoardEcho >> $LOGPATH/$LOGFILE

    if [ -f "/usr/local/bin/minfo-app.sh" ]; then
              
        /usr/local/bin/minfo-app.sh
        /usr/local/bin/minfo-app.sh >> $LOGPATH/$LOGFILE
        
    fi
    
    if [ -f "/usr/local/bin/minfo-sv2.sh" ]; then
    
        /usr/local/bin/minfo-sv2.sh              
        /usr/local/bin/minfo-sv2.sh >> $LOGPATH/$LOGFILE
        
    fi

echo    
echo -e ${YELLOW}"     Log file <$LOGFILE> created in $LOGPATH directory."${NC}
echo

#for security mount system back to READ-ONLY when finished
#mount -o remount,ro /
