#!/bin/bash

SYSTEMD_OFFLINE=1 /bin/systemctl is-enabled systemd-timesyncd

# Only run the actual daemon when the service is explicitely enabled by user setting.
if [ "$?" != "0" ]; then
    # We need to notify systemd to make it believe that the service has "started" 
    # or else it's going to restart the service.
    echo "Run \"systemd-notify --ready\"..."
    exec systemd-notify --ready
fi

exec /lib/systemd/systemd-timesyncd
