#!/bin/sh

CURRENTROOTMOUNT=$( mount | grep "on / type" | cut -f2 -d'(' | cut -f1 -d',' )

if [ "$1" == "ro" ]; then
    systemctl mask serial-getty@ttyS0.service
    rm /etc/fstab ; ln -s /etc/fstab.ro /etc/fstab
    # Re-mount root with read-only access.
    mount -o remount,ro,sync /

    if [ "$?" == "0" ]; then
        /sbin/mount-copybind /var/volatile/lib /var/lib
        echo "File system successfully mounted read-only"
    else
        echo "File system will be mounted read-only on next reboot"
    fi

else
    # Re-mount root with read-write access.
    mount -o remount,rw,async /
    umount /var/lib
    systemctl unmask serial-getty@ttyS0.service
    
    if ! [ -f "/etc/fstab.rw" ]; then
        # Create files.
        cp /etc/fstab /etc/fstab.ro
        cp /etc/fstab /etc/fstab.rw
        sed -i -e "s/ro,/defaults,/" /etc/fstab.rw
        sed -i -e "s/,ro/,defaults/" /etc/fstab.rw
        sed -i -e "s/ ro / defaults /" /etc/fstab.rw
        sed -i -e "s/sync,/defaults,/" /etc/fstab.rw
        sed -i -e "s/,sync/,defaults/" /etc/fstab.rw
        sed -i -e "s/ sync / defaults /" /etc/fstab.rw
    fi    
    
    rm /etc/fstab ; ln -s /etc/fstab.rw /etc/fstab
    echo "File system successfully mounted read-write"
fi
