#!/bin/sh

RWPATH="/dev/mmcblk0p2"
info1=/rw/firmware/info1.gg
info2=/rw/firmware/info2.gg
info3=/rw/firmware/info3.gg
P2PKOMH=/rw/config/P2PKeepOverlayMessagesHidden
echo Resetting configuration settings to manufacturer defaults...
#if [ "$(ls /rw/config/point_to_point_mode >& /dev/null ; echo $?)" == "0" ]; then RESETTX=1 ; fi
touch /rw/resetting
/usr/sbin/MtxBoardFactoryReset-NoDrv
/usr/sbin/MtxResetCtrl-NoDrv -fr
HARDWAREREVISION=$(cat /rw/firmware/hardwareversion)
PCB=$(cat /etc/device/info1.gg | grep PcbNumber | cut -f2 -d'=' | cut -f1 -d'-')

if [ "${PCB}" == "7514" ]; then

    /usr/sbin/MtxResetOnLan-NoDrv -sr 492550
    /usr/sbin/MtxResetCtrl-NoDrv -wold

fi

if [ -f /rw/config/BootMark.txt ]; then
  BOOTMARK=$(cat /rw/config/BootMark.txt)
else
  BOOTMARK=""
fi

ls -l $info1

if [ "$?" == "0" ]; then

  INFOFILE1=$(ls -l $info1 | cut -f2 -d'>')

fi

ls -l $info2

if [ "$?" == "0" ]; then

  INFOFILE2=$(ls -l $info2 | cut -f2 -d'>')

fi

if [ -f "/rw/firmware/info3.gg" ]; then

  INFOFILE3=$(< $info3)

fi

if [ -f "$P2PKOMH" ]; then
  P2PKeepOverlayMsg=$(< $P2PKOMH)
fi

umount /rw
yes | mkfs.ext4 $RWPATH
mount $RWPATH /rw
mkdir /rw/firmware/

if [ "$INFOFILE1" != "" ]; then

  ln -s $INFOFILE1 $info1

fi

if [ "$INFOFILE2" != "" ]; then

  ln -s $INFOFILE2 $info2

fi

tar -zxf /rw.tar.gz -C /rw/
mkdir -p /rw/usr/local/SV2

if [ -f "/exe.config.tar.gz" ]; then

  tar -zxf /exe.config.tar.gz -C /rw/

fi

source /etc/device/info1.gg
echo $SerialNumber > /rw/shared/etc/hostname

echo "$HARDWAREREVISION" > /rw/firmware/hardwareversion

echo "$INFOFILE3" > $info3

echo "$P2PKeepOverlayMsg" > $P2PKOMH

if [ "$BOOTMARK" != "" ]; then
  echo "$BOOTMARK" > /rw/config/BootMark.txt
fi

if [ "$RECOVERCONNMAN" == "1" ]; then
    tar -zxf /connman.tar.gz -C /rw/shared/var/lib/connman/
fi

if [ -f "/etc/device/info2.gg" ]; then

  CUSTOM_NTP_SERVER=$(cat /etc/device/info2.gg | grep "NTPSERVER" | cut -f2 -d'=')
  
  if [ "${CUSTOM_NTP_SERVER}" != "" ]; then
  
      echo "[Time]" > /rw/shared/etc/systemd/timesyncd.conf
      echo "NTP=${CUSTOM_NTP_SERVER}" >> /rw/shared/etc/systemd/timesyncd.conf
      echo "FallbackNTP=time.matrox.com" >> /rw/shared/etc/systemd/timesyncd.conf
  
  fi

fi

if [ -f $info3 ]; then
        # invalidating entries in info3.gg
        echo "invalidating"
        sed -i "s/^\(EAP_TLS_CERTIFICATE=\).*$/\1unknown/" $info3
        sed -i "s/^\(SYSLOG_CERT=\).*$/\1unknown/" $info3
fi


if [ -f /sbin/resetex.sh ]; then
  /sbin/resetex.sh
fi

#if [ "${RESETTX}" == "1" ]; then touch /rw/boot/resettx ; fi
touch /rw/boot/reseteth

sync


