#!/bin/bash

if [ -f /rw/boot/reseteth ]; then

    source /etc/device/info1.gg
    source /etc/device/info2.gg
    
    if [ "${DEFAULTIPV}" == "4" ] || [ "${DEFAULTIPV}" == "6" ]; then
    
        for MAC in $(ifconfig | grep HWaddr | cut -f2 -d'W' | cut -f2 -d' ' | sed "s/://g") ; do
        
            if [ $(/usr/bin/connmanctl services | grep "${MAC,,}" >& /dev/null; echo $?) == "0" ]; then
            
                echo "Found service for ${MAC}"        
                SERVICE=$(/usr/bin/connmanctl services | grep "${MAC,,}" | cut -f18 -d' ')
                
                if [ "${DEFAULTIPV}" == "6" ]; then

                    /usr/bin/connmanctl config ${SERVICE} --ipv4 off

                else

                    /usr/bin/connmanctl config ${SERVICE} --ipv6 off

                fi
            
            else
            
                if [ $(ls /var/lib/connman/ethernet_${MAC,,}_cable/settings >& /dev/null ; echo $?) == "0" ]; then
                
                    echo "Found settings file for ${MAC}"
                
                    if [ "${DEFAULTIPV}" == "6" ]; then

                        sed -i -e 's|IPv4.method=dhcp|IPv4.method=off|g' /var/lib/connman/ethernet_${MAC,,}_cable/settings

                    else

                        sed -i -e 's|IPv6.method=auto|IPv6.method=off|g' /var/lib/connman/ethernet_${MAC,,}_cable/settings

                    fi
                
                else
                
                    echo "Creating settings file for ${MAC}"
                    mkdir -p /var/lib/connman/ethernet_${MAC,,}_cable
                    echo "[ethernet_${MAC,,}_cable]" > /var/lib/connman/ethernet_${MAC,,}_cable/settings
                    
                    if [ "${DEFAULTIPV}" == "6" ]; then

                        echo "IPv4.method=off" >> /var/lib/connman/ethernet_${MAC,,}_cable/settings

                    else

                        echo "IPv6.method=off" >> /var/lib/connman/ethernet_${MAC,,}_cable/settings

                    fi
                
                fi
            
            fi
        
        done
    
    fi

    rm /rw/boot/reseteth

fi
