/************************************************************************************************************\

Module Name:    VpeModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_VpeModule_H
#define INC_VpeModule_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleThread.h"
#include "ModuleLink.h"
#include "LVideoProcessor.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Structure:      VpeModule

Description:    Module for Liberatus video processor.

\************************************************************************************************************/
typedef struct tagVpeModule
{
    LDeviceThread_Handle    hDevThread;
    LDeviceThread_Handle    hDevThread2;
    LVPE_Handle             hVpe;
    LVPE_Handle             hVpe2;
    LVPC_Handle             hVpc;
    ModuleThread            oCpuThread;
    ModuleLinkInput         oInLink;
    ModuleLink              oOutLink;
    MBOOL                   bUseVpc;
    MBOOL                   bSplitVpe;
    MBOOL                   bDeinterlace;
    LSIZE                   oBufferSize;
    LVP_Rect                oSrcRect;
    LVP_Rect                oDstRect;
    LVP_Rect                oClipRect;
    LVP_Rect                oSrcRect2;
    LVP_Rect                oDstRect2;
    MCHAR8                  szModuleName[16];

} VpeModule;

#define VpeModule_Construct { /*.hDevThread         =*/ MNULL, \
                              /*.hDevThread2        =*/ MNULL, \
                              /*.hVpe               =*/ MNULL, \
                              /*.hVpe2              =*/ MNULL, \
                              /*.hVpc               =*/ MNULL, \
                              /*.oCpuThread         =*/ ModuleThread_Construct, \
                              /*.oInLink            =*/ ModuleLinkInput_Construct, \
                              /*.oOutLink           =*/ ModuleLink_Construct, \
                              /*.bUseVpc            =*/ MFALSE, \
                              /*.bSplitVpe          =*/ MFALSE, \
                              /*.bDeinterlace       =*/ MFALSE}


// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus VpeMod_Init(VpeModule*           poVpeMod,
                    LDevice_Handle       hDevice,
                    MUINT                uiOutBufferCount,
                    LBuffer_Attributes*  poOutBufferAttributes,
                    MBOOL                bInterlaced);
void VpeMod_Cleanup(VpeModule* poVpeMod);
LStatus VpeMod_SetRectangles(VpeModule *poVpeMod,
                             const LRECT32* poSrcRect,
                             const LRECT32* poDstRect,
                             const LRECT32* poClipRect);
LStatus VpeMod_Start(VpeModule* poVpeMod);
void VpeMod_Stop(VpeModule* poVpeMod);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

static __inline  LStatus LVPE_SetSrcRect(LVPE_Handle hVpe, LVP_Rect* poSrcRect)
{
    return LVPE_SetSourceParam(hVpe, LVPE_Source_SOURCE_RECT, sizeof(LVP_Rect), poSrcRect);
}

static __inline  LStatus LVPE_SetDstRect(LVPE_Handle hVpe, LVP_Rect* poDstRect)
{
    return LVPE_SetSourceParam(hVpe, LVPE_Source_DESTINATION_RECT, sizeof(LVP_Rect), poDstRect);
}

static __inline  LStatus LVPE_SetClipRect(LVPE_Handle hVpe, LVP_Rect* poClipRect)
{
    return LVPE_SetTargetParam(hVpe, LVPE_Target_RECT, sizeof(LVP_Rect), poClipRect);
}

static __inline  LStatus LVPE_Execute(LVPE_Handle hVpe, LBuffer_Handle hSrcBuffer, LBuffer_Handle hDstBuffer)
{
    return LVPE_ExecuteFrame(hVpe, hDstBuffer, LVPE_CurrentFrameOrField_FRAME, MNULL, hSrcBuffer, MNULL);
}

static __inline LStatus LVPC_SetSrcRect(LVPC_Handle hVpc, MUINT uiSrcIdx,  LVP_Rect* poSrcRect)
{
    return LVPC_SetSourceParam(hVpc, uiSrcIdx, LVPC_Source_SOURCE_RECT, sizeof(LVP_Rect), poSrcRect);
}

static __inline LStatus LVPC_SetDstRect(LVPC_Handle hVpc, MUINT uiSrcIdx, LVP_Rect* poDstRect)
{
    return LVPC_SetSourceParam(hVpc, uiSrcIdx, LVPC_Source_DESTINATION_RECT, sizeof(LVP_Rect), poDstRect);
}

static __inline  LStatus LVPC_SetClipRect(LVPC_Handle hVpc, LVP_Rect* poClipRect)
{
    return LVPC_SetTargetParam(hVpc, LVPC_Target_RECT, sizeof(LVP_Rect), poClipRect);
}

static __inline LStatus LVPC_Execute(LVPC_Handle hVpc, LBuffer_Handle hSrcBuffer, LBuffer_Handle hDstBuffer,
                                     MBOOL bReadWrite)
{
    LVPC_SourceData aoSrcData[2];

    aoSrcData[0].bEnable        = MTRUE;
    aoSrcData[0].hInputSurface  = hSrcBuffer;
    aoSrcData[1].bEnable        = MTRUE;
    aoSrcData[1].hInputSurface  = hDstBuffer;

    return LVPC_ExecuteFrame(hVpc, hDstBuffer, bReadWrite ? 2 : 1, aoSrcData);
}

#endif // INC_VpeModule_H
