/************************************************************************************************************\

Module Name:    VoutModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_VoutModule_H
#define INC_VoutModule_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleLink.h"
#include "ModuleThread.h"
#include "ModuleSync.h"
#include "LVideoOut.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

typedef MBOOL (*PfnGetMstStrmTimeUsec)(void* pvData, MUINT64* puiStreamTime);

/************************************************************************************************************\

Structure:      VoutModule

Description:    Video out module (software for emulation).

\************************************************************************************************************/
typedef struct tagVoutModule
{
    LDevice_Handle              hDevice;
    LVideoOut_Handle            hVout;
    MUINT                       uiVoutIdx;
    ModuleLinkInput             oInLink;
    ModuleThread                oCpuThread;
    ModuleSync                  oModSync;
    MBOOL                       bIsMasterSync;
    LBuffer_Handle              hFrameBuffer;
    MUINT                       uiInFrameRateNum;
    MUINT                       uiInFrameRateDen;
    MBOOL                       bControlQueueOverflow;
    MBOOL                       bLowLatency;
    LVideo_VidParam             oVidParam;
    MCHAR8                      szModuleName[16];

} VoutModule;

#define VoutModule_Construct { /*.hDevice                       =*/ MNULL, \
                               /*.hVout                         =*/ MNULL, \
                               /*.uiVoutIdx                     =*/ 0, \
                               /*.oInLink                       =*/ ModuleLinkInput_Construct, \
                               /*.oCpuThread                    =*/ ModuleThread_Construct, \
                               /*.oModSync                      =*/ ModuleSync_Construct, \
                               /*.bIsMasterSync                 =*/ MTRUE, \
                               /*.hFrameBuffer                  =*/ MNULL, \
                               /*.uiInFrameRateNum              =*/ 60, \
                               /*.uiInFrameRateDen              =*/ 1, \
                               /*.bControlQueueOverflow         =*/ MTRUE, \
                               /*.bLowLatency                   =*/ MFALSE}

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus VoutMod_Init(VoutModule*                poVout,
                     LDevice_Handle             hDevice,
                     MUINT                      uiVoutIdx,
                     LPixelFormat               ePixFmt,
                     LSIZE*                     poDisplaySize,
                     MUINT                      uiDisplayFps,
                     MUINT                      uiInFrameRateNum,
                     MUINT                      uiInFrameRateDen,
                     MBOOL                      bControlQueueOverflow,
                     MBOOL                      bIsMasterSync,
                     MBOOL                      bLowLatency);
void VoutMod_Cleanup(VoutModule* poVout);
LStatus VoutMod_SetInputFrameRate(VoutModule* poVout,
                                  MUINT       uiInFrameRateNum,
                                  MUINT       uiInFrameRateDen);
LStatus VoutMod_SetOutputFormat(
    VoutModule*  poVout,
    LPixelFormat ePixFmt,
    MBOOL        bRgbFullYuv709);
LStatus VoutMod_Start(VoutModule* poVout);
void VoutMod_Stop(VoutModule* poVout);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_VoutModule_H
