/************************************************************************************************************\

Module Name:    VoutGlxModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_VoutGlxModule_H
#define INC_VoutGlxModule_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#define GL_GLEXT_PROTOTYPES
#include <X11/X.h>
#include <GL/gl.h>
#include <GL/glx.h>
#include <GL/glext.h>

#include "Liberatus.h"
#include "LBlit.h"
#include "CommonUtils.h"
#include "ModuleLink.h"
#include "ModuleThread.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Structure:      VoutGlxModule

Description:    Video out module for baytrail output using OGL in X-window (GLX).

\************************************************************************************************************/
typedef struct tagVoutGlxModule
{
    ModuleLinkInput         oInLink;
    ModuleThread            oCpuThread;
    Display*                hDisplay;
    LSIZE                   oWindowSize;
    MUINT                   uiWinWidthBytes;
    MUINT                   uiWinSizeBytes;
    Window                  uiWindowId;
    GLXContext              hGlxCtx;
    GLuint                  uiGlBufferId;
    GLuint                  uiGlTextureId;
    LBuffer_Handle          hTmpBuffer;
    MUINT                   uiTmpBufferPitchBytes;
    LDeviceThread_Handle    hDevThread;
    LBlit_Handle            hBlit;
    MUINT                   uiInFrameRateNum;
    MUINT                   uiInFrameRateDen;
    MBOOL                   bControlQueueOverflow;
    MCHAR8                  szModuleName[16];

} VoutGlxModule;

#define VoutGlxModule_Construct {/*.oInLink                 =*/ ModuleLinkInput_Construct, \
                                 /*.oCpuThread              =*/ ModuleThread_Construct, \
                                 /*.hDisplay                =*/ MNULL, \
                                 /*.oWindowSize             =*/ {0, 0}, \
                                 /*.uiWinWidthBytes         =*/ 0, \
                                 /*.uiWinSizeBytes          =*/ 0,\
                                 /*.uiWindowId              =*/ 0, \
                                 /*.hGlxCtx                 =*/ MNULL, \
                                 /*.uiGlBufferId            =*/ 0, \
                                 /*.uiGlTextureId           =*/ 0, \
                                 /*.hTmpBuffer              =*/ MNULL, \
                                 /*.uiTmpBufferPitchBytes   =*/ 0,\
                                 /*.hDevThread              =*/ MNULL, \
                                 /*.hBlit                   =*/ MNULL, \
                                 /*.uiInFrameRateNum        =*/ 60, \
                                 /*.uiInFrameRateDen        =*/ 1, \
                                 /*.bControlQueueOverflow   =*/ MTRUE }

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus VoutGlxMod_Init(
            VoutGlxModule* poVoutGlx,
            LDevice_Handle hDevice,
            LRECT*         poWindowRect,
            MUINT          uiInFrameRateNum,
            MUINT          uiInFrameRateDen,
            MBOOL          bControlQueueOverflow);
void VoutGlxMod_Cleanup(VoutGlxModule* poVoutGlx);
LStatus VoutGlxMod_SetInputFrameRate(
            VoutGlxModule*  poVoutGlx,
            MUINT           uiInFrameRateNum,
            MUINT           uiInFrameRateDen);
LStatus VoutGlxMod_Start(VoutGlxModule* poVoutGlx);
void VoutGlxMod_Stop(VoutGlxModule* poVoutGlx);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_VoutGlxModule_H
