/************************************************************************************************************\

Module Name:    VinModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_VinModule_H
#define INC_VinModule_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleLink.h"
#include "ModuleThread.h"
#include "LVideoIn.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Structure:      VinModule

Description:    Video-in module to capture video signal.

\************************************************************************************************************/
typedef struct tagVinModule
{
    LDevice_Handle  hDevice;
    LVideoIn_Handle hVin;
    ModuleThread    oCpuThread;
    ModuleLink      oOutLink;
    MUINT32         uiTickFrequency;
    MBOOL           bFailSafe;
    MBOOL           bInternalBufferCreated;
    MBOOL           bLowLatency;
    LSIZE           oFrameSize;
    LPixelFormat    ePixelFormat;
    MUINT           uiFrameRate1000x;
    MUINT           uiFrameDurationTick;
    MBOOL           bInterlaced;
    MUINT64         uiElapsedTimeUsec;
    MUINT           uiTotalFrameCount;
    MUINT           uiCapturedFrameCount;
    MUINT           uiRateDivisor;
    MUINT           uiSkipPeriod;
    MBOOL           bSourceModeValid;
    LBuffer_Handle* pahVinBufferHandle;
    MUINT32         uiNbOfVinBufferHandle;
    MUINT32         uiVinBufferCurrentIndex;
    MCHAR8          szModuleName[16];
    LVideo_VidParam oVidParam;

} VinModule;

#define VinModule_Construct { /*.hDevice                =*/ MNULL, \
                              /*.hVin                   =*/ MNULL, \
                              /*.oCpuThread             =*/ ModuleThread_Construct, \
                              /*.oOutLink               =*/ ModuleLink_Construct, \
                              /*.uiTickFrequency        =*/ 0, \
                              /*.bFailSafe              =*/ MFALSE, \
                              /*.bInternalBufferCreated =*/ MFALSE, \
                              /*.bLowLatency            =*/ MFALSE, \
                              /*.oFrameSize             =*/ {0, 0}, \
                              /*.ePixelFormat           =*/ LPixelFormat_ALIAS_ABGR32, \
                              /*.uiFrameRate1000x       =*/ 0, \
                              /*.uiFrameDurationTick    =*/ 0, \
                              /*.bInterlaced            =*/ MFALSE, \
                              /*.uiElapsedTimeUsec      =*/ 0, \
                              /*.uiTotalFrameCount      =*/ 0, \
                              /*.uiCapturedFrameCount   =*/ 0, \
                              /*.uiRateDivisor          =*/ 1, \
                              /*.uiSkipPeriod           =*/ 0, \
                              /*.bSourceModeValid       =*/ MFALSE, \
                              /*.pahVinBufferHandle     =*/ MNULL,  \
                              /*.uiNbOfVinBufferHandle  =*/ 0,      \
                              /*.uiVinBufferCurrentIndex=*/ 0,      \
                              /*.szModuleName           =*/ ""}

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus VinMod_Init(VinModule*      poVinMod,
                    LDevice_Handle  hDevice,
                    MUINT           uiVinIndex,
                    MUINT           uiBufferCount,
                    MUINT           uiRateDivisor,
                    MUINT           uiSkipPeriod,
                    LPixelFormat    ePreferredPixFmt,
                    MBOOL           bLowLatency);
void    VinMod_Cleanup(VinModule* poVinMod);
LStatus VinMod_GetSourceMode(VinModule* poVinMod, LPixelFormat ePreferredPixFmt);
LStatus VinMod_Start(VinModule* poVinMod);
void    VinMod_Stop(VinModule* poVinMod);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_VinModule_H
