/************************************************************************************************************\

Module Name:    RtspServerModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_RtspServerModule_H
#define INC_RtspServerModule_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleThread.h"
#include "ModuleLink.h"
#include "LNetStreamer.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

// Ittiam is limited to this size.
static const MUINT g_uiMaxNaluSize = 2940936;

/************************************************************************************************************\

Structure:      RtspServerModule

\************************************************************************************************************/
typedef struct
{
    MBOOL                   bInit;
    MBOOL                   bEnableVideo;
    ModuleLinkInput         oVideoInLink;
    ModuleThread            oMainCpuThread;
    LDevice_Handle          hDevice;
    MBOOL                   bSessionStarted;
    MBOOL                   bUnresponsive;
    MUINT                   uiMaxNaluSizeBytes;
    char                    szFolderName[80];
    char                    szServerLocation[256];
    char                    szRtmpPushLocation[256];
    char                    szUsername[256];
    char                    szPassword[256];
    char                    szAddress[64];
    LNetStreamer_Protocol   eProtocol;
    MUINT                   uiVideoPort;
    MUINT64                 uiStartTimeUsec;
    MBOOL                   bEnableAudio;
    ModuleLinkInput         oAudioInLink;
    ModuleThread            oChildCpuThread;
    MUINT                   uiAudioPort;
    MUINT                   uiMaxAudioBufSizeBytes;
    MUINT                   uiMtu;
    MUINT16                 uiAudioSpecificConfig;
    MUINT64                 uiLastAudioTsUsec;
    MCHAR8                  szModuleName[16];
    MBOOL                   bEnableSrt;
    MUINT                   uiHlsDuration;
    MUINT                   uiHlsCount;
    char                    szHlsFolder[256];
    MCHAR8                  szHlsMaster[16];
    MCHAR8                  szNetInterface[128];
    MBOOL                   bEnableIpv6;
    LNetStreamer_SrtMode    eSrtMode;
} RtspServerModule;

#define RtspServerModule_Construct {/*.bInit                    =*/ MFALSE, \
                                    /*.bEnableVideo             =*/ MFALSE, \
                                    /*.oVideoInLink             =*/ ModuleLinkInput_Construct, \
                                    /*.oMainCpuThread           =*/ ModuleThread_Construct, \
                                    /*.hDevice                  =*/ MNULL, \
                                    /*.bSessionStarted          =*/ MFALSE, \
                                    /*.bUnresponsive            =*/ MFALSE, \
                                    /*.uiMaxNaluSizeBytes       =*/ 0, \
                                    /*.szFolderName             =*/ {0}, \
                                    /*.szServerLocation         =*/ {0}, \
                                    /*.szRtmpPushLocation       =*/ {0}, \
                                    /*.szUsername               =*/ {0}, \
                                    /*.szPassword               =*/ {0}, \
                                    /*.szAddress                =*/ {0}, \
                                    /*.eProtocol                =*/ LNetStreamer_Protocol_RTSP, \
                                    /*.uiVideoPort              =*/ 0, \
                                    /*.uiStartTimeUsec          =*/ 0, \
                                    /*.bEnableAudio             =*/ MFALSE, \
                                    /*.oAudioInLink             =*/ ModuleLinkInput_Construct, \
                                    /*.oChildCpuThread          =*/ ModuleThread_Construct, \
                                    /*.uiAudioPort              =*/ 0, \
                                    /*.uiMaxAudioBufSizeBytes   =*/ 0, \
                                    /*.uiMtu                    =*/ 0, \
                                    /*.uiAudioSpecificConfig    =*/ 0, \
                                    /*.uiLastAudioTsUsec        =*/ 0, \
                                    /*.szModuleName             =*/ "", \
                                    /*.bEnableSrt               =*/ MFALSE, \
                                    /*.uiHlsDuration            =*/ 0, \
                                    /*.uiHlsCount               =*/ 0, \
                                    /*.szHlsFolder              =*/ {0}, \
                                    /*.szHlsMaster              =*/ {0}, \
                                    /*.szNetInterface           =*/ {0}, \
                                    /*.bEnableIpv6              =*/ MFALSE, \
                                    /*.eSrtMode                 =*/ (LNetStreamer_SrtMode)(0) \
}


// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus RtspSrvMod_Init(
            RtspServerModule*       poRtspSrvMod,
            LDevice_Handle          hDevice);

void RtspSrvMod_Cleanup(
            RtspServerModule*       poRtspSrvMod);

LStatus RtspSrvMod_SetParams(
            RtspServerModule*       poRtspSrvMod,
            MUINT                   uiMaxNaluSizeBytes,
            MUINT                   uiMaxAudioBufSizeBytes,
            const char*             szFolderName,
            const char*             szAddress,
            MBOOL                   bEnableVideo,
            MUINT                   uiVideoPort,
            MBOOL                   bEnableAudio,
            MUINT                   uiAudioPort,
            MUINT16                 uiAudioSpecificConfig,
            LNetStreamer_Protocol   eProtocol,
            const char*             szRtmpPushLocation,
            const char*             szUsername,
            const char*             szPassword,
            MUINT                   uiMtu,
            MBOOL                   bEnableSrt,
            MUINT                   uiHlsDuration,
            MUINT                   uiHlsCount,
            const char*             szHlsFolder,
            const char*             szHlsMaster,
            const char*             szNetInterface,
            MBOOL                   bEnableIpv6,
            LNetStreamer_SrtMode    eSrtMode);

LStatus RtspSrvMod_Start(
            RtspServerModule* poRtspSrvMod);

void RtspSrvMod_Stop(
            RtspServerModule* poRtspSrvMod);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_RtspServerModule_H
