/************************************************************************************************************\

Module Name:    MosaicModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_MosaicModule_H
#define INC_MosaicModule_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleThread.h"
#include "ModuleLink.h"
#include "LVideoProcessor.h"
#include "LBlit.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

#define MOSAIC_MAX_INPUT    (16)
#define MOSAIC_VPE_COUNT    (2)
#define MOSAIC_VPC_COUNT    (1)
#define MOSAIC_SYNC_DT_IDX  (0)
#define MOSAIC_VPE_DT_IDX   (MOSAIC_SYNC_DT_IDX + 1)
#define MOSAIC_VPC_DT_IDX   (MOSAIC_VPE_DT_IDX + MOSAIC_VPE_COUNT)
#define MOSAIC_DT_COUNT     (1 + MOSAIC_VPE_COUNT + MOSAIC_VPC_COUNT)

/************************************************************************************************************\

Structure:      MosaicInputParam

Description:    Per input parameters.

\************************************************************************************************************/
typedef struct tagMosaicInputParam
{
    LVP_Rect                oSrcRect;
    LVP_Rect                oDstRect;
    MBOOL                   bUseVpc;
    LSIZE                   oSrcFrameSize;
    MUINT                   uiFrameRateNum;
    MUINT                   uiFrameRateDen;
    MUINT                   uiZOrder;
    MBOOL                   bControlQueueOverflow;
    MFLOAT32                fAlpha;

} MosaicInputParam;

/************************************************************************************************************\

Structure:      MosaicInputData

Description:    Dynamic data of each input.

\************************************************************************************************************/
typedef struct tagMosaicInputData
{
    MUINT           uiInputIndex;
    MINT64          iTimestampOffsetNsec;
    MUINT64         uiFrameDurationNsec;
    MUINT64         uiPresentTimeNsec;
    MUINT64         uiMaxTimeDriftNsec;
    MUINT           uiMaxQueueLenAllowed;
    BufferInfo*     poCurBuffer;
    MBOOL           bEos;
    LClipRgn_Handle hClipRgn;

} MosaicInputData;

/************************************************************************************************************\

Structure:      MosaicModule

Description:    Module for Liberatus video processor.

\************************************************************************************************************/
typedef struct tagMosaicModule
{
    LDeviceThread_Handle    ahDevThread[MOSAIC_DT_COUNT];
    LVPE_Handle             ahVpe[MOSAIC_VPE_COUNT];
    LVPC_Handle             ahVpc[MOSAIC_VPC_COUNT];
    LBlit_Handle            hBlit;
    ModuleThread            oCpuThread;
    ModuleLink              oOutLink;
    ModuleLinkInput         aoInLink[MOSAIC_MAX_INPUT];
    MBOOL                   bInitParam;
    LClipRgn_Handle         hFullClipRgn;
    void*                   pfnSubmitNotify;
    MBOOL                   bSyncInputs;
    MBOOL                   bLowLatency;
    LVP_Rect                oFullDstRect;
    MosaicInputParam        aoInParam[MOSAIC_MAX_INPUT];
    MUINT                   uiOutFrameRateNum;
    MUINT                   uiOutFrameRateDen;
    MosaicInputData         aoInData[MOSAIC_MAX_INPUT];
    MUINT                   uiInputCount;
    MBOOL                   bShowFullScreen;
    MUINT                   uiFullScreenInputIdx;
    MCHAR8                  szModuleName[16];

} MosaicModule;

#define MosaicModule_Construct { /*.ahDeviceThread     =*/ { MNULL, MNULL, MNULL, MNULL }, \
                                 /*.ahVpe              =*/ { MNULL, MNULL }, \
                                 /*.ahVpc              =*/ { MNULL }, \
                                 /*.ahBlit             =*/ MNULL, \
                                 /*.oCpuThread         =*/ ModuleThread_Construct, \
                                 /*.oOutLink           =*/ ModuleLink_Construct, \
                                 /*.aoInLink           =*/ { ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct, \
                                                             ModuleLinkInput_Construct }, \
                                /*.bInitParam          =*/ MFALSE, \
                                /*.hFullDstRgn         =*/ MNULL, \
                                /*.pfnSubmitNotify     =*/ MNULL,\
                                /*.bSyncInputs         =*/ MFALSE, \
                                /*.bLowLatency         =*/ MFALSE }

typedef void (*MosMod_SubmitNotifyFn)(MosaicModule* poMosMod, MBOOL bEos);

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus MosMod_Init(MosaicModule*           poMosMod,
                    LDevice_Handle          hDevice,
                    MUINT                   uiOutBufferCount,
                    LBuffer_Attributes*     poOutBufferAttributes,
                    LSIZE*                  poOutFrameSize,
                    MosMod_SubmitNotifyFn   pfnSubmitNotify,
                    MBOOL                   bSyncInputs,
                    MBOOL                   bLowLatency);
void MosMod_Cleanup(MosaicModule* poMosMod);
LStatus MosMod_GetOutputFrameRate(MosaicModule*   poMosMod,
                                  MUINT*          puiFrameRateNum,
                                  MUINT*          puiFrameRateDen);
LStatus MosMod_SetParameters(MosaicModule*  poMosMod,
                             MUINT          uiInputIndex,
                             const LSIZE*   poSrcFrameSize,
                             const LRECT32* poSrcRect,
                             const LRECT32* poDstRect,
                             MUINT          uiFrameRateNum,
                             MUINT          uiFrameRateDen,
                             MUINT          uiZOrder,
                             MBOOL          bControlQueueOverflow,
                             MFLOAT32       fAlpha);
LStatus MosMod_Start(MosaicModule* poMosMod);
void MosMod_Stop(MosaicModule* poMosMod);
void MosMod_ShowOneInputFullScreen(MosaicModule* poMosMod, MBOOL bEnable, MUINT uiInputIndex);
LStatus MosMod_MoveDstRect(MosaicModule* poMosMod, MUINT uiInputIndex, const LPOS* poOffset);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_MosaicModule_H
