/************************************************************************************************************\

Module Name:    AoutModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_AoutModule_H
#define INC_AoutModule_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"
#include "CommonUtils.h"
#include "ModuleThread.h"
#include "ModuleSync.h"
#include "LAudioOut.h"
#include "LAudioFormat.h"
#include "LAudioProcessor.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Structure:      AoutModule

Description:    Audio out module.

\************************************************************************************************************/
typedef struct tagAoutModule
{
    LDevice_Handle      hDevice;
    LAudioOut_Handle    hAout;
    LAudioProc_Handle   hProc;
    MUINT32             uiTickFrequency;
    ModuleLinkInput     oInLink;
    ModuleThread        oCpuThread;
    ModuleSyncMaster*   poModSyncMst;
    LAudioFormat        eFormat;
    MUINT32             uiFramesPerInputBuffer;
    MUINT32             uiFramesPerOutputBuffer;
    MUINT32             uiBytesPerSample;
    LBuffer_Handle      hSilenceBuffer;
    MUINT32             uiBufferSize;
    MBOOL               bUseProcessor;
    MBOOL               bDoClkComp;
    MBOOL               bQueueLvlClkComp;
    MFLOAT64            fTotalBufferingCummul;
    MUINT32             uiBufferingAvgCnt;
    MFLOAT64            fDirectCtrlLvl;
    MUINT64             uiLastInputTs;
    MUINT64             uiTotConsumedSamples;
    MCHAR8              szModuleName[16];

} AoutModule;

#define AoutModule_Construct { /*.hDevice                       =*/ MNULL, \
                               /*.hAout                         =*/ MNULL, \
                               /*.hProc                         =*/ MNULL, \
                               /*.uiTickFrequency               =*/ 0, \
                               /*.oInLink                       =*/ ModuleLinkInput_Construct, \
                               /*.oCpuThread                    =*/ ModuleThread_Construct, \
                               /*.poModSyncMst                  =*/ MNULL, \
                               /*.eFormat                       =*/ LAudioFormat_INVALID, \
                               /*.uiFramesPerInputBuffer        =*/ 0, \
                               /*.uiFramesPerOutputBuffer       =*/ 0, \
                               /*.uiBytesPerSample              =*/ 0, \
                               /*.hSilenceBuffer                =*/ MNULL, \
                               /*.uiBufferSize                  =*/ 0, \
                               /*.bUseProcessor                 =*/ MFALSE, \
                               /*.bDoClkComp                    =*/ MFALSE, \
                               /*.bQueueLvlClkComp              =*/ MFALSE, \
                               /*.TotalBufferingCummul          =*/ 0.0, \
                               /*.uiBufferingAvgCnt             =*/ 0, \
                               /*.fDirectCtrlLvl                =*/ 0.0, \
                               /*.uiLastInputTs                 =*/ 0, \
                               /*.uiTotConsumedSamples          =*/ 0, \
                               /*.szModuleName                  =*/ "" }

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus AoutMod_Init(
            AoutModule*         poAout,
            LDevice_Handle      hDevice,
            MUINT32             uiAoutIndex,
            LAudioFormat        eFormat,
            MUINT32             uiFramesPerBuffer,
            ModuleSyncMaster*   poSlaveModSync,
            MBOOL               bDoClkComp,
            MBOOL               bQueueLvlClkComp);

void AoutMod_Cleanup(
            AoutModule*         poAout);

LStatus AoutMod_Start(
            AoutModule*         poAout);

void AoutMod_Stop(
            AoutModule*         poAout);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_AoutModule_H
