/************************************************************************************************************\

Module Name:    AoutAlsaModule.h

Description:    .

    Copyright (c) 2015, Matrox Graphics Inc. All Rights Reserved.

    BSD 2-Clause License

    Redistribution and use in source and binary forms, with or without modification, are permitted provided
    that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this list of conditions and the
       following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
       the following disclaimer in the documentation and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
    PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
    ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

\************************************************************************************************************/

#ifndef INC_AOUTALSAMODULE_H
#define INC_AOUTALSAMODULE_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "CommonUtils.h"
#include "ModuleThread.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Structure:      AoutAlsaModule

Description:    Audio out ALSA module.

\************************************************************************************************************/
typedef struct tagAoutAlsaModule
{
    MHANDLE             hAlsaDev;
    MUINT32             uiDevIdx;
    ModuleLinkInput     oInLink;
    ModuleThread        oCpuThread;
    MUINT32             uiSamplingRate;
    MUINT32             uiNbChannels;
    MUINT32             uiSampleSize;
    MBOOL32             bBigEndian;
    MBOOL32             bUnsigned;
    MUINT32             uiFramesPerBuffer;

} AoutAlsaModule;

#define AoutAlsaModule_Construct { /* .hAlsaDev           =*/ MNULL, \
                                   /* .uiDevIdx           =*/ 0, \
                                   /* .oInLink            =*/ ModuleLinkInput_Construct, \
                                   /* .oCpuThread         =*/ ModuleThread_Construct, \
                                   /* .uiSamplingRate     =*/ 0, \
                                   /* .uiNbChannels       =*/ 0, \
                                   /* .uiSampleSize       =*/ 0, \
                                   /* .bBigEndian         =*/ MFALSE, \
                                   /* .bUnsigned          =*/ MFALSE, \
                                   /* .uiFramesPerBuffer  =*/ 0 }

// -----------------------------------------------------------------------------------------------------------
//                  G L O B A L   V A R I A B L E / F U N C T I O N   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

LStatus AoutAlsaMod_EnumDevices(
            MUINT32*        puiNbDevices);

LStatus AoutAlsaMod_GetDeviceName(
            MUINT32         uiDeviceIdx,
            LSTR64*         pszName);

LStatus AoutAlsaMod_Init(
            AoutAlsaModule* poAout,
            MUINT32 uiDevIdx,
            MUINT32 uiSamplingRate,
            MUINT32 uiNbChannels,
            MUINT32 uiSampleSize,
            MBOOL32 bBigEndian,
            MBOOL32 bUnsigned,
            MUINT32 uiFramesPerBuffer);

void AoutAlsaMod_Cleanup(
            AoutAlsaModule* poAout);

LStatus AoutAlsaMod_Start(
            AoutAlsaModule* poAout);

void AoutAlsaMod_Stop(
            AoutAlsaModule* poAout);

// -----------------------------------------------------------------------------------------------------------
//                                 I N L I N E S   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif // INC_AOUTALSAMODULE_H
