################################################################################
#
# CMake Script used to find Liberatus
# Search for Liberatus_in this order
# 1. Already defined CMakeVariable LIBERATUS_INCLUDE_DIRS, LIBERATUS_LIBRARIES,
# 2. Environnement variable LIBERATUS_SRC_DIR, LIBERATUS_BIN_DIR,
# 3. Environnement variable  LIBERATUS_DIR, where liberatus may be installed. (Not working right now) 
# 4. Default system path install location.   (Prefered way on Linux)
#
# This script defined the following variables
# LIBERATUS_FOUND
# LIBERATUS_INCLUDE_DIRS
# LIBERATUS_LIBRARIES
################################################################################

if( ${CMAKE_SIZEOF_VOID_P} EQUAL 8)
    set(ARCH_STR "64")
else()
    set(ARCH_STR "32")
endif()

set(LIBERATUS_MAIN_HEADER Liberatus.h)
set(LIBERATUS_MAIN_LIBRARY Liberatus)

if (NOT LIBERATUS_FOUND)
    # Search for LIBERATUS_INCLUDE_DIRS and LIBERATUS_LIBRARIES
    if (DEFINED LIBERATUS_INCLUDE_DIRS)
        if (DEFINED LIBERATUS_LIBRARIES)
            set( LIBERATUS_FOUND true)
        else (DEFINED LIBERATUS_LIBRARIES)
            message(WARNING "LIBERATUS_INCLUDE_DIRS is defined but not LIBERATUS_LIBRARIES, fall back on other method to find Liberatus")
        endif(DEFINED LIBERATUS_LIBRARIES)
    endif (DEFINED LIBERATUS_INCLUDE_DIRS)
endif(NOT LIBERATUS_FOUND)

if (NOT LIBERATUS_FOUND)
    # No LIBERATUS_INCLUDE_DIRS defined Check for Environnement variables 
    if (DEFINED ENV{LIBERATUS_SRC_DIR})
        if (DEFINED ENV{LIBERATUS_BIN_DIR})
            find_path( LIBERATUS_INCLUDE_DIRS 
                       NAMES LiberatusLayer/PublicInterface/${LIBERATUS_MAIN_HEADER} 
                       PATHS ENV{LIBERATUS_SRC_DIR})
            find_library( LIBERATUS_LIBRARIES_SEARCH_A
                          NAMES ${LIBERATUS_MAIN_LIBRARY}
                          PATHS ${LIBERATUS_BIN_DIR}/LiberatusLayer/DeviceLayer.Imp)
            find_library( SV2_LIBRAIRIES_SEARCH
                          NAMES sv2
                          PATHS ${LIBERATUS_BIN_DIR}/DeviceLayer/UmDriver/DriverLinux)
            if (LIBERATUS_INCLUDE_DIRS AND LIBERATUS_LIBRARIES_SEARCH_A AND SV2_LIBRAIRIES_SEARCH)
                set(LIBERATUS_FOUND true) 
                set(LIBERATUS_LIBRARIES ${LIBERATUS_LIBRARIES_SEARCH_A} ${SV2_LIBRAIRIES_SEARCH} pthread rt )
            endif()
        else (DEFINED ENV{LIBERATUS_BIN_DIR})
            message(WARNING "LIBERATUS_SRC_DIR is defined but not LIBERATUS_BIN_DIR, fall back on other method to find Liberatus")
        endif (DEFINED ENV{LIBERATUS_BIN_DIR})    
    endif(DEFINED ENV{LIBERATUS_SRC_DIR})
endif (NOT LIBERATUS_FOUND)

if (NOT LIBERATUS_FOUND)
    # No Check for system path for liberatus 
    find_path( LIBERATUS_INCLUDE_DIRS 
               NAMES ${LIBERATUS_MAIN_HEADER} 
               PATHS /usr/include/liberatus /usr/local/include/liberatus)
    find_library( LIBERATUS_LIBRARIES_SEARCH_A
                  NAMES ${LIBERATUS_MAIN_LIBRARY}
                  PATHS /usr/lib /usr/local/lib)
    find_library( SV2_LIBRAIRIES_SEARCH 
                  NAMES sv2
                  PATHS /usr/lib /usr/local/lib)
    if (LIBERATUS_INCLUDE_DIRS AND LIBERATUS_LIBRARIES_SEARCH_A AND SV2_LIBRAIRIES_SEARCH)
        set(LIBERATUS_FOUND true) 
        set(LIBERATUS_LIBRARIES ${LIBERATUS_LIBRARIES_SEARCH_A} ${SV2_LIBRAIRIES_SEARCH} pthread rt)
   endif()
endif(NOT LIBERATUS_FOUND)

if( NOT LIBERATUS_FOUND)
    message(FATAL ERROR "Unable to find Liberatus")
endif( NOT LIBERATUS_FOUND)

mark_as_advanced(LIBERATUS_FOUND LIBERATUS_LIBRARIES LIBERATUS_INCLUDE_DIRS)

set(LIBERATUS_FOUND ${LIBERATUS_FOUND} CACHE BOOL "Is Liberatus is found")
set(LIBERATUS_LIBRARIES ${LIBERATUS_LIBRARIES} CACHE FILEPATH "Liberatus libraries")
set(LIBERATUS_INCLUDE_DIRS ${LIBERATUS_INCLUDE_DIRS} CACHE PATH "Liberatus include diretories")
