#!/bin/bash
# Matrox Info Script 01 07 2020

#This script will display Sv2 driver and FPGA information 
#----------

RED='\033[0;31m'
NC='\033[0m' # No Color
LTGREEN='\033[1;32m'   
WHITE='\033[1;01m'
BLUE='\033[1;34m'
PATHTOTOOLS=/usr/local/bin

function DisplayBoardInfo()
{
PNAME=$(${PATHTOTOOLS}/${MTXBOARDINFO} | grep ProductName | cut -f20 -d' ')
SERIAL=$(${PATHTOTOOLS}/${MTXBOARDINFO} | grep SerialNumber | cut -f19 -d' ')
DEVICEID=$(${PATHTOTOOLS}/${MTXBOARDINFO} | grep DeviceId | cut -f23 -d ' ')
SUBSYSID=$(${PATHTOTOOLS}/${MTXBOARDINFO} | grep SubSystemId | cut -f20 -d ' ')
PCB=$(${PATHTOTOOLS}/${MTXBOARDINFO} | grep PcbNumber: | cut -f22 -d ' ')
HMC=$(${PATHTOTOOLS}/${MTXBOARDINFO} | grep FirmwareVersion: | cut -f16 -d ' ')
FPGA=$(${PATHTOTOOLS}/${FPGAVAR} | grep Device)
SV2FAN=$(${PATHTOTOOLS}/${SV2FANVAR} | grep fan | cut -f2 -d'@')
SV2TEMPERATURE=$(${PATHTOTOOLS}/${SV2TEMPERATUREVAR} | grep GPU | cut -f2 -d'#')
LIBERATUS=$(${PATHTOTOOLS}/${MTXBOARDINFO} | grep "Liberatus v" | cut -f2 -d'v')
REFERENCE=$(${PATHTOTOOLS}/${MTXBOARDINFO} | grep ReferenceID | cut -f2 -d' ')
PINSRELEASEDATE=$(${PATHTOTOOLS}/${MTXBOARDINFO} | grep "PInS release date:(YYYY-MM-DD)" | cut -f4 -d ' ')
DisplayBoardInfoecho
}

function DisplayBoardInfoecho()
{
        echo "Product Name:                   ${PNAME}" 
        echo "Serial Number:                  ${SERIAL}"
        echo "Device ID:                      ${DEVICEID}"
        echo "SubSysID:                       ${SUBSYSID}"
        echo "PcbNumber:                      ${PCB}"
        echo "HMC FirmwareVersion:            ${HMC}"
        echo "Liberatus Version:              ${LIBERATUS}"
        echo "Reference ID:                   ${REFERENCE}"
        echo "Pins Release Date:              ${PINSRELEASEDATE}"
        echo
        echo "Fan Speed:                      ${SV2FAN}"
        echo "SV2 Temperature:"
        echo "$SV2TEMPERATURE"
        echo
        echo -e ${WHITE}"FPGA Information"${NC}
        echo "    $FPGA"
        echo
        date
        echo -e ${BLUE}"################################################################################"${NC}

}


cd ${PATHTOTOOLS} 

SV2DRIVER=$(lsmod | grep sv2 >& /dev/null ; echo $?)
SV2DRIVERSTALLED=$(cat /dev/sv20 2>&1 >/dev/null | grep "open" >& /dev/null ; echo $?)

if [ ${SV2DRIVER} -eq "0" ] && [ ${SV2DRIVERSTALLED} -eq "1" ]; then
   MTXBOARDINFO=MtxBoardInfo
   SV2FANVAR=Sv2Fan
   SV2TEMPERATUREVAR=Sv2Temperature
   FPGAVAR=MtxGetFpgaInfo
   echo -e ${LTGREEN}"SV2 driver is loaded."${NC}
else
   MTXBOARDINFO=MtxBoardInfo-NoDrv
   SV2FANVAR=Sv2Fan-NoDrv
   SV2TEMPERATUREVAR=Sv2Temperature-NoDrv
   FPGAVAR=MtxFpgaFlasher
   
   if [ ${SV2DRIVER} -eq "0" ]; then
       echo -e ${RED}"SV2 driver is loaded, but stalled (check dmesg for details)."${NC} 
   else   
       echo -e ${RED}"SV2 driver is not loaded."${NC} 
   fi
fi

DisplayBoardInfo
