#!/bin/bash

modules=(\
  "/usr/share/sv2/shim.ko" \
  "/usr/share/sv2/sv2.ko" );

fail()
{
  echo Opps, we failed!
  /bin/ps -o pid,args -p $(fuser /dev/sv20 2>/dev/null)
  exit -1
}
findmod()
{
  lsmod | grep "$1  *[0-9]"
}
_rmmod()
{
  if findmod $1>/dev/null; then
    echo Removing module $1
    rmmod $1 || fail
  fi
}

main()
{
  if [ "$?" == "0" ]; then
  
    sleep 2
  
  fi
  
  killall MtxProgressBarDisplay-NoDrv

  # Removing the modules (reversed order)
  nb_modules=${#modules[@]}
  for ((idx=nb_modules-1; idx>=0; idx--)); do
    fname=`basename ${modules[$idx]}`
    module_name=${fname%.*}
    _rmmod $module_name
  done

  # Insert the modules
  if [ -f /usr/share/sv2/shim.ko ]; then
    echo "Inserting module shim.ko"
    insmod /usr/share/sv2/shim.ko || fail
  fi

  echo "Inserting module sv2.ko"
  insmod /usr/share/sv2/sv2.ko MessageLevel=451 TopologyTimeoutMs=0 || fail

  # Wait for udev event to complete (in case the SV20 node creation is handled by udev).
  udevadm settle

  # make sure the node exists
  if [ ! -e "/dev/sv20" ]; then
      # The below line will fetch the output string and remove the sv2: 247 sv2
      sv2node=$(cat /proc/devices | grep sv2 | cut -f1 -d' ')
      mknod -m 0666 /dev/sv20 c $sv2node 0
  fi
}

main
exit 0
