/************************************************************************************************************\

Module Name:    LiberatusExt.h

Description:    .

References:     None.

    Copyright (c) 2015, Matrox Graphics Inc.
    All Rights Reserved.

\************************************************************************************************************/

// -----------------------------------------------------------------------------------------------------------
//                                  I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "Liberatus.h"

// -----------------------------------------------------------------------------------------------------------
//                         N A M E S P A C E ,   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------
#if defined (__cplusplus)
extern "C" {
#endif

typedef struct LBLITEXT_OBJECT* LBlitExt_Handle;

LAPI MUINT32 LiberatusExt_Version();
LAPI void LiberatusExt_Test(LDevice_Handle hDevice);

/************************************************************************************************************\

Function:       LBlitExt_Create

Description:    Create a LBlitExt context.

Parameters:     IN  hDevice         Handle to a device.
                IN  hDeviceThread   Handle to a device thread.
                OUT phContext       Pointer on the handle to the LBlit context.

Return Value:   LStatus_OK              The operation completed successfully.
                LStatus_FAIL            The operation failed.
                LStatus_OUT_OF_MEMORY   Failed because no more memory is available.
                LStatus_INVALID_PARAM   Failed because a parameter is invalid.

Comments:       When the handle is not used anymore, it must be destroyed using LBlitExt_Destroy.

\************************************************************************************************************/
LAPI LStatus LBlitExt_Create
(
    LDevice_Handle       hDevice,
    LDeviceThread_Handle hDeviceThread,
    LBlitExt_Handle*     phContext
);

/************************************************************************************************************\

Function:       LBlitExt_Destroy

Description:    Destroy the LBlitExt context and all the resources attached to it.

Parameters:     IN hContext     Handle to the LBlitExt context.

Return Value:   LStatus_OK              The operation completed successfully.
                LStatus_FAIL            The operation failed.
                LStatus_INVALID_PARAM   Failed because a parameter is invalid.

Comments:       None.

\************************************************************************************************************/
LAPI LStatus LBlitExt_Destroy
(
    LBlitExt_Handle hContext
);
/************************************************************************************************************\

Function:       LBlitExt_BlitOverPCIe

Description:    Copy a rectangle between two video buffers with same pixel size.

Parameters:     IN hContext             Handle to the LBlit context.
                IN hSrcBuffer           Handle to the source buffer.
                IN hDstBuffer           Handle to the destination buffer.
                IN uiPCIeBufferOffset   Offset in bytes for the PCIe Buffer.
                IN poSrcPos             Position in the source buffer. The resulting source rectangles
                                        must be inside the boundaries of the source buffer. It cannot
                                        be NULL.
                IN poDstRect            Rectangle into the destination buffer. The rectangle will be
                                        clipped to the boundaries of the clippping region. It cannot be NULL.

Return Value:   LStatus_OK              The operation completed successfully.
                LStatus_FAIL            The operation failed.
                LStatus_INVALID_PARAM   Failed because a parameter is invalid.

Comments:      None.

\************************************************************************************************************/
LAPI LStatus LBlitExt_BlitOverPCIe
(
    LBlitExt_Handle hContext,
    LBuffer_Handle  hSrcBuffer,
    LBuffer_Handle  hDstBuffer,
    MUINT32         uiPCIeBufferOffset,
    LPOS32*         poSrcPos,
    LRECT32*        poDstRect
);

#if defined (__cplusplus)
}
#endif

