/************************************************************************************************************\

Module Name:    LSecureEngine.h

Description:

References:

    Copyright (c) 2017, Matrox Graphics Inc.
    All Rights Reserved.

\************************************************************************************************************/

#ifndef INC_LSECUREENGINE_H
#define INC_LSECUREENGINE_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "LStatus.h"
#include "Liberatus.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------
#define LSECUREENGINE_STATUS_ABORT_PERIOD       15  // in sec
#define LSECUREENGINE_STATUS_PERIOD             3   // in sec
#define LSECUREENGINE_SESSION_ABORT_PERIOD      15  // in sec
#define LSECUREENGINE_SESSION_PERIOD            5   // in sec
#define LSECUREENGINE_CONTENT_PERIOD            3   // in sec
#define LSECUREENGINE_CONTENT_PACKET_MAX_KEYS   16

// -----------------------------------------------------------------------------------------------------------
//                                   U S A G E
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                                   O V E R V I E W
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\
Overview:


Description:

\************************************************************************************************************/

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

typedef struct LSECUREENGINE_OBJECT* LSecureEngine_Handle;

typedef MUINT8   LSecureEngine_Packet[928];

typedef MUINT8   LSecureEngine_String128[16]; // 128 bit octet string


/************************************************************************************************************\

Structure:      LDevice_SecureMemory

Description:

Comments:       None.

\************************************************************************************************************/
typedef enum {
    LDevice_SecureMemory_ENABLE    = 0,
    LDevice_SecureMemory_DISABLE   = 1,
    LDevice_SecureMemory_ONDEMAND  = 2,
} LDevice_SecureMemoryType;

/************************************************************************************************************\

Structure:     LDevice_GetSecureMemoryState

Description:

Comments:       None.

\************************************************************************************************************/
typedef enum {
    LDevice_GetSecureMemoryState_NONE     = 0,
    LDevice_GetSecureMemoryState_SAFE     = 1,
    LDevice_GetSecureMemoryState_BEST     = 2,
} LDevice_GetSecureMemoryStateType;

/************************************************************************************************************\

Enum:           LSecureEngine_AttributeType

Description:    Enumeration of attribute types.

Comments:       None.

\************************************************************************************************************/
typedef enum {
    LSecureEngine_AttributeType_CREATE  = 0,            // Attributes structure for the Create method.
    LSecureEngine_AttributeType_FORCE32 = 0x7FFFFFFF,   // Dummy value to force to use 32-bits.
} LSecureEngine_AttributeType;

/************************************************************************************************************\

Enum:           LSecureEngine_ChannelType

Description:    Enumeration of attribute types.

Comments:       None.

\************************************************************************************************************/
typedef enum
{
    LSecureEngine_ChannelType_DH = 1,
    LSecureEngine_ChannelType_DH_MPX,
    LSecureEngine_ChannelType_DH_CSERIES,
} LSecureEngine_ChannelType;

/************************************************************************************************************\

Structure:      LSecureEngine_CreateAttributes

Description:    Device thread creation attributes.

Comments:       LDeviceThread_AttributeType_CREATE.

\************************************************************************************************************/
typedef struct tagLSecureEngine_CreateAttributes
{
    LSecureEngine_AttributeType eType;                      // Shall be LDeviceThread_AttributeType_CREATE
    LSecureEngine_ChannelType   eChannelType;
    LSecureEngine_String128     oSubGroupKey;
} LSecureEngine_CreateAttributes;

typedef struct LSecureEngine_ContentKey
{
    LSecureEngine_String128 oMAC;          // MAC of the whole structure
    LSecureEngine_String128 oIV;           // IV of the session key encrypted with the engine key
    LSecureEngine_String128 oContentKey;   // encrypted AES-CTR128 with the session key
    LSecureEngine_String128 oWrappingIV;   // IV of the content key
    LSecureEngine_String128 oMediaIVCTR;   // IVCTR of the media content
    LSecureEngine_String128 oSessionKey;   // encrypted AES-CFB128 with the engine key
    MUINT                   uiSessionKeyId;// Session key id (for validation)
    MUINT                   uiReserved;
} LSecureEngine_ContentKey;

// -----------------------------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                         G L O B A L   F U N C T I O N   D E C L A R A T I O N S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                      I N L I N E S   A N D   T E M P L A T E   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------
#if defined (__cplusplus)
extern "C" {
#endif

/************************************************************************************************************\

Function:       LSecureEngine_Create

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_Create(
                LDevice_Handle                   hDev,
                LSecureEngine_AttributeType*     poAttributes,
                LSecureEngine_Handle*            phSecureEngine);

/************************************************************************************************************\

Function:       LSecureEngine_Destroy

Description:    Destroys a secure engine object.

Parameters:

Return Value:   LStatus_OK                  Function completed successfully.
                LStatus_INVALID_PARAM       Function failed due to invalid parameters.
                LStatus_FAIL                Function failed.

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_Destroy(
                LSecureEngine_Handle    hSecureEngine);

/************************************************************************************************************\

Function:       LSecureEngine_GetDiffieHellmanInitPacket

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_GetDiffieHellmanInitPacket(
                LSecureEngine_Handle  hSecureEngine,
                LSecureEngine_Packet* poNodePacket,
                LSecureEngine_Packet* poInitPacket);

/************************************************************************************************************\

Function:       LSecureEngine_PutDiffieHellmanInitPacket

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_PutDiffieHellmanInitPacket(
                LSecureEngine_Handle  hSecureEngine,
                LSecureEngine_Packet* poNodePacket,
                LSecureEngine_Packet* poLinkPacket,
                LSecureEngine_Packet* poInitPacket);

/************************************************************************************************************\

Function:       LSecureEngine_GetRsaInitPacket

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_GetRsaInitPacket(
                LSecureEngine_Handle  hSecureEngine,
                LSecureEngine_Packet* poNodePacket,
                LSecureEngine_Packet* poInitPacket,
                LSecureEngine_Packet* poLinkPacket);

/************************************************************************************************************\

Function:       LSecureEngine_RipInitPacket

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_RipInitPacket(
                LSecureEngine_Handle  hSecureEngine,
                LSecureEngine_Packet* poNodePacket,
                LSecureEngine_Packet* poLinkPacket);

/************************************************************************************************************\

Function:       LSecureEngine_GetSessionKey

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_GetSessionKey(
                LSecureEngine_Handle  hSecureEngine,
                LSecureEngine_Packet* poNodePacket);

/************************************************************************************************************\

Function:       LSecureEngine_PutSessionKey

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_PutSessionKey(
                LSecureEngine_Handle  hSecureEngine,
                LSecureEngine_Packet* poNodePacket);

/************************************************************************************************************\

Function:       LSecureEngine_GetContentKey

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_GetContentKey(
                LSecureEngine_Handle      hSecureEngine,
                LSecureEngine_Packet*     poNodePacket,
                LSecureEngine_ContentKey* poContentKey);

/************************************************************************************************************\

Function:       LSecureEngine_GetContentPacket

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_GetContentPacket(
                LSecureEngine_Handle      hSecureEngine,
                LSecureEngine_Packet*     poNodePacket,
                LSecureEngine_Packet*     poLinkPacket,
                LSecureEngine_Packet*     poContentPacket,
                LSecureEngine_Packet*     poNextContentPacket,
                LSecureEngine_ContentKey* paoContentKey,
                MUINT                     uiContentKeyCount);

/************************************************************************************************************\

Function:       LSecureEngine_PutContentPacket

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_PutContentPacket(
                LSecureEngine_Handle      hSecureEngine,
                LSecureEngine_Packet*     poNodePacket,
                LSecureEngine_Packet*     poLinkPacket,
                LSecureEngine_Packet*     poContentPacket,
                LSecureEngine_ContentKey* paoContentKey,
                MUINT*                    puiContentKeyCount);

/************************************************************************************************************\

Function:       LSecureEngine_GetStatusPacket

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_GetStatusPacket(
                LSecureEngine_Handle  hSecureEngine,
                LSecureEngine_Packet* poNodePacket,
                LSecureEngine_Packet* poLinkPacket,
                LSecureEngine_Packet* poStatusPacket,
                MBOOL*                pbNodeStatus,
                MBOOL*                pbLinkStatus);

/************************************************************************************************************\

Function:       LSecureEngine_PutStatusPacket

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_PutStatusPacket(
                LSecureEngine_Handle  hSecureEngine,
                LSecureEngine_Packet* poNodePacket,
                LSecureEngine_Packet* poLinkPacket,
                LSecureEngine_Packet* poStatusPacket,
                MBOOL*                pbNodeStatus,
                MBOOL*                pbLinkStatus);

/************************************************************************************************************\

Function:       LSecureEngine_GetMessagePacket

Description:

Parameters:

Return Value:

Comments:

\************************************************************************************************************/
LAPI LStatus LSecureEngine_GetMessagePacket(
                LSecureEngine_Handle  hSecureEngine,
                LSecureEngine_Packet* poNodePacket,
                LSecureEngine_Packet* poLinkPacket,
                LSecureEngine_Packet* poMessagePacket);

/************************************************************************************************************\

Function:       LSecureEngine_PutMessagePacket

Description:    

Parameters:

Return Value:

Comments:       

\************************************************************************************************************/
LAPI LStatus LSecureEngine_PutMessagePacket(
                LSecureEngine_Handle  hSecureEngine,
                LSecureEngine_Packet* poNodePacket,
                LSecureEngine_Packet* poLinkPacket,
                LSecureEngine_Packet* poMessagePacket);

/************************************************************************************************************\

Function:       LSecureEngine_Encrypt

Description:    

Parameters:

Return Value:

Comments:       

\************************************************************************************************************/
LAPI LStatus LSecureEngine_Encrypt(
                LSecureEngine_Handle        hSecureEngine,
                LBuffer_Handle              hSrcBuffer,
                LBuffer_Handle              hDstBuffer,
                MUINT32                     uiSrcOffset,
                MUINT32                     uiDstOffset,
                MUINT32                     uiSize,
                LSecureEngine_ContentKey*   poKey,
                MUINT64                     uiCounter);

/************************************************************************************************************\

Function:       LSecureEngine_Decrypt

Description:    

Parameters:

Return Value:

Comments:       

\************************************************************************************************************/
LAPI LStatus LSecureEngine_Decrypt(
                LSecureEngine_Handle        hSecureEngine,
                LBuffer_Handle              hSrcBuffer,
                LBuffer_Handle              hDstBuffer,
                MUINT32                     uiSrcOffset,
                MUINT32                     uiDstOffset,
                MUINT32                     uiSize,
                LSecureEngine_ContentKey*   poKey,
                MUINT64                     uiCounter);

/************************************************************************************************************\

Function:       LDevice_SecureMemory

Description:    

Parameters:

Return Value:

Comments:       

\************************************************************************************************************/
LAPI LStatus LDevice_SecureMemory(LDevice_Handle            hDevice,
                                  LDevice_SecureMemoryType  eSecureMemory);

/************************************************************************************************************\

Function:       LDevice_GetSecureMemoryState

Description:    

Parameters:

Return Value:

Comments:       

\************************************************************************************************************/
LAPI LStatus LDevice_GetSecureMemoryState(LDevice_Handle                    hDevice,
                                          LDevice_GetSecureMemoryStateType* peGetSecureMemoryState);

#if defined (__cplusplus)
}
#endif

#endif  // #ifndef INC_LSECUREENGINE_H
