/************************************************************************************************************\

Module Name:    LAudio.h

Description:    Liberatus audio input/output header file.

References:     None.

    Copyright (c) 2014, Matrox Graphics Inc.
    All Rights Reserved.

\************************************************************************************************************/

#ifndef INC_LAUDIO_H
#define INC_LAUDIO_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "LVideo.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Enum:           LAudio_SignalType

Description:    Enumeration defining the possible types of audio signal for capture and playback.

Comments:       - More information about Connectors can be found in LBoard API.

\************************************************************************************************************/
typedef enum
{
    LAudio_SignalType_NONE            = 0x00000000,   // Nothing connected.

    LAudio_SignalType_USEDEFAULT      = 0x00000001,   // Use default signal type (wild card).

    LAudio_SignalType_ANALOG          = 0x00000010,   // Analog Audio signal.

    LAudio_SignalType_ANALOG_2_0      = 0x00000011,   // Analog Audio signal.
    LAudio_SignalType_ANALOG_4_0      = 0x00000012,   // Analog Audio signal.
    LAudio_SignalType_ANALOG_5_1      = 0x00000013,   // Analog Audio signal.
    LAudio_SignalType_ANALOG_7_1      = 0x00000014,   // Analog Audio signal.

    LAudio_SignalType_HDMI            = 0x00000020,   // Digital Audio 3 lines TMDS (HDMI).

    LAudio_SignalType_DISPLAYPORT     = 0x00000030,   // Digital Audio DisplayPort (1, 2 or 4 lines).

    LAudio_SignalType_SPDIF           = 0x00000040,   // Digital Audio SPDIF interface.

    LAudio_SignalType_SDI             = 0x00000080,   // SDI

    LAudio_SignalType_FORCE32         = 0x7FFFFFFF,   // Dummy value to force enumeration to use 32 bits.

} LAudio_SignalType;

/************************************************************************************************************\

Enum:           LAudio_State

Description:    Enumeration defining all possible state values.

Comments:       None.

\************************************************************************************************************/
typedef enum
{
    LAudio_State_INVALID          = 0x00000000,   // Invalid value.
    LAudio_State_NOT_INITIALIZED  = 0x00000001,   // The interface is not initialized and can't be started
                                                  // until properly initialized.
    LAudio_State_INITIALIZED      = 0x00000002,   // The interface is initialized and can be started.
    LAudio_State_START_PENDING    = 0x00000003,   // The interface is started but is waiting on an external
                                                  // event to be signaled to start.
    LAudio_State_STARTED          = 0x00000004,   // The interface is started.
    LAudio_State_STOPPED          = 0x00000005,   // The interface is stopped, but is still initialized and
                                                  // can be restarted.
    LAudio_State_FORCE32          = 0x7FFFFFFF,   // Dummy value to force enumeration to use 32-bits.
} LAudio_State;

/************************************************************************************************************\

Struct:         LAudio_InfoFrameHeader

Description:    Structure defining an audio InfoFrame header.

Comments:       None.

\************************************************************************************************************/
typedef struct tagLAudio_InfoFrameHeader
{
    MUINT32 uiType;     // Audio InfoFrame packet ID value.
    MUINT32 uiVersion;  // Audio InfoFrame packet version value.
    MUINT32 uiLength;   // Audio InfoFrame packet length value.
} LAudio_InfoFrameHeader;

// -----------------------------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                         G L O B A L   F U N C T I O N   D E C L A R A T I O N S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                      I N L I N E S   A N D   T E M P L A T E   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif  // #ifndef INC_LAUDIO_H
