/************************************************************************************************************\

Module Name:    LAnc.h

Description:    Liberatus ancillary data input/output header file.

References:     None.

    Copyright (c) 2014, Matrox Graphics Inc.
    All Rights Reserved.

\************************************************************************************************************/

#ifndef INC_LANC_H
#define INC_LANC_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

#include "LVideo.h"

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------

/************************************************************************************************************\

Enum:           LAnc_SignalType

Description:    Enumeration defining the possible types of anc signal for capture and playback.

Comments:       - More information about Connectors can be found in LBoard API.

\************************************************************************************************************/
typedef enum
{
    LAnc_SignalType_NONE            = 0x00000000,   // Nothing connected.

    LAnc_SignalType_USEDEFAULT      = 0x00000001,   // Use default signal type (wild card).

    LAnc_SignalType_SDI             = 0x00000011,   // SDI

    LAnc_SignalType_FORCE32         = 0x7FFFFFFF,   // Dummy value to force enumeration to use 32 bits.

} LAnc_SignalType;

/************************************************************************************************************\

Enum:           LAnc_State

Description:    Enumeration defining all possible state values.

Comments:       None.

\************************************************************************************************************/
typedef enum
{
    LAnc_State_INVALID          = 0x00000000,     // Invalid value.
    LAnc_State_NOT_INITIALIZED  = 0x00000001,     // The interface is not initialized and can't be started
                                                  // until properly initialized.
    LAnc_State_INITIALIZED      = 0x00000002,     // The interface is initialized and can be started.
    LAnc_State_START_PENDING    = 0x00000003,     // The interface is started but is waiting on an external
                                                  // event to be signaled to start.
    LAnc_State_STARTED          = 0x00000004,     // The interface is started.
    LAnc_State_STOPPED          = 0x00000005,     // The interface is stopped, but is still initialized and
                                                  // can be restarted.
    LAnc_State_FORCE32          = 0x7FFFFFFF,     // Dummy value to force enumeration to use 32-bits.
} LAnc_State;


/************************************************************************************************************\

Structure:      LAnc_BufferFormat

Description:    Format of an ancillary data buffer.

Comments:       Each 10-bit User Data Words is stored in a WORD; therefore there is a 4 bits padding
                in each WORD.

\************************************************************************************************************/
#pragma pack(push, 1)
typedef struct tagLAnc_BufferFormat
{
    MUINT16  uiLineNumber;
    MUINT8   uiWrappingType;
    MUINT8   uiPayloadSampleCoding;
    MUINT8   uiDID_Bit_0_7;
    MUINT8   uiSDID_Bit_0_7;
    MUINT    uiDataCount        : 10;
    MUINT    uiDID_Bit_8_9      :  2;
    MUINT    uiSDID_Bit_8_9     :  2;
    MUINT    uiPadding          :  2;
    MUINT16  auiData[255];
} LAnc_BufferFormat;
#pragma pack(pop)

// -----------------------------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                         G L O B A L   F U N C T I O N   D E C L A R A T I O N S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                      I N L I N E S   A N D   T E M P L A T E   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif  // #ifndef INC_LANC_H
