/************************************************************************************************************\

Module Name:    LAPI.h

Description:    Defines LAPI macro that is used to export function when building Liberatus as a 
                shared library.
                
                When building a shared library please define in your build systems L_EXPORTS.
                
                On gcc please specified the the following arguments -fvisibility=hidden

References:     None.

    Copyright (c) 2014, Matrox Graphics Inc.
    All Rights Reserved.

\************************************************************************************************************/

#ifndef INC_LAPI_H
#define INC_LAPI_H

// -----------------------------------------------------------------------------------------------------------
//                                   I N C L U D E S   A N D   U S I N G S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                                   C O N S T A N T S   A N D   T Y P E S
// -----------------------------------------------------------------------------------------------------------
#ifdef _WIN32
    #if  defined (Liberatus_EXPORTS) || defined (L_EXPORTS)
        #define LAPI  __declspec(dllexport)
    #elif defined  (L_IMPORTS) || defined (Liberatus_IMPORT) 
         #define LAPI  __declspec(dllimport)
    #else
      #define LAPI
    #endif
#else
  #if __GNUC__ >= 4
    #define LAPI    __attribute__ ((visibility ("default")))
  #else
    #define LAPI
  #endif
#endif

// -----------------------------------------------------------------------------------------------------------
//                           G L O B A L   V A R I A B L E   R E F E R E N C E S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                         G L O B A L   F U N C T I O N   D E C L A R A T I O N S
// -----------------------------------------------------------------------------------------------------------

// -----------------------------------------------------------------------------------------------------------
//                      I N L I N E S   A N D   T E M P L A T E   D E F I N I T I O N S
// -----------------------------------------------------------------------------------------------------------

#endif  // #ifndef INC_LAPI_H
