#!/bin/bash
#This script will return all server and app specific information regarding Extio3
#verify services for Extio 3
            #extio3_xorg.service
            #extio3_rx.service
            #extio3_tx.service
            #sv2_command-webservice-host.service
            
            
EXTIO3SERVICE_SV2_UPDATER_WEBSERVICE_HOST=$(systemctl is-active sv2_updater-webservice-host)

echo 
echo "EXTIO3 APP INFORMATION"

if [ -e /lib/systemd/system/extio3_rx.service ]; then
     EXTIO3SERVICE_XORG_SERVICE=$(systemctl is-active extio3_xorg.service)
     EXTIO3RXSERVICE=$(systemctl is-active extio3_rx.service)
     EXTIO3RXPACKVERSION=$(rpm -q --queryformat "%{version}.%{release}\n" Extio3RxPack)                     
     EXTIO3USBIPRXVERSION=$(rpm -q --queryformat "%{version}-%{release}\n" usbip-rx)
     EXTIO3SERVICE_SV2_COMMAND_WEBSERVICE_HOST=$(systemctl is-active sv2_command-webservice-host-core)
                    
else
     EXTIO3RXPACKVERSION="unknown"
     EXTIO3USBIPRXVERSION="unknown"
     EXTIO3RXSERVICE="inactive"
fi

if [ -e /lib/systemd/system/extio3_tx.service ]; then
     EXTIO3TXSERVICE=$(systemctl is-active extio3_tx.service)
     EXTIO3TXPACKVERSION=$(rpm -q --queryformat "%{version}.%{release}\n" Extio3TxPack)
     EXTIO3USBIPTXVERSION=$(rpm -q --queryformat "%{version}-%{release}\n" usbip-tx)
     EXTIO3SERVICE_SV2_COMMAND_WEBSERVICE_HOST=$(systemctl is-active sv2_command-webservice-host-core)

else
     EXTIO3TXPACKVERSION="unknown"
     EXTIO3USBIPTXVERSION="unknown"
     EXTIO3TXSERVICE="inactive"
fi

if [ "${EXTIO3RXPACKVERSION}" == "unknown" ]; then
    echo "EXTIO3 RX Services:             Not active"         
else
    echo "EXTIO3 RX Service:              ${EXTIO3RXSERVICE}"
    echo "EXTIO3 RX Pack Version:         ${EXTIO3RXPACKVERSION}"
    echo "EXTIO3 RX USB IP Version:       ${EXTIO3USBIPRXVERSION}"          
    echo "EXTIO3 cmd-webservice-host:     ${EXTIO3SERVICE_SV2_COMMAND_WEBSERVICE_HOST}"
    echo "EXTIO3 Xorg Service:            ${EXTIO3SERVICE_XORG_SERVICE}"
fi

if [ "${EXTIO3TXPACKVERSION}" == "unknown" ]; then
    echo "EXTIO3 TX Services:             Not active"         
else
    echo "EXTIO3 TX Service:              ${EXTIO3TXSERVICE}"
    echo "EXTIO3 TX Pack Version:         ${EXTIO3TXPACKVERSION}"
    echo "EXTIO3 TX USB IP Version:       ${EXTIO3USBIPTXVERSION}"          
    echo "EXTIO3 cmd-webservice-host-core ${EXTIO3SERVICE_SV2_COMMAND_WEBSERVICE_HOST}"
fi
    echo "EXTIO3 updater-webservice-host: ${EXTIO3SERVICE_SV2_UPDATER_WEBSERVICE_HOST}"
